(function ($, fwEvents) {

	fwEvents.on('fw:options:init', function (data) {
		data.$elements.find('.fw-option-type-thz-icon:not(.thz-option-initialized)').each(function(index, element) {

			var $element 				= $(element);
			var $iconsholder 			= $element.find('.thz-icon-input');
			var $icon_name  			= $element.find('.thz-icon-name');
			var $add_icons				= $iconsholder.attr('data-add-icons');
			var $remove_icons			= $iconsholder.attr('data-remove-icons');
			var $remove_categories		= $iconsholder.attr('data-remove-categories');
			var $categories				= $iconsholder.attr('data-categories');
			var thz_icons_list			= $.extend(true, {}, thz_icon_source);
			var thz_icons_search_list	= $.extend(true, {}, thz_icon_search);
			var $customIconsPack		= typeof _thicon !== 'undefined' ? _thicon.packs : false;

			// global custom packs
			if( $customIconsPack ){
				
				try{
					
					$customIconsPack = JSON.parse($customIconsPack);
					$.each($customIconsPack,function(cat,items){
						
						if(thz_icons_list[cat] ==  undefined){
							thz_icons_list[cat] =[];
						}
						
						for (var i = 0; i < items.length; i++) {
							thz_icons_list[cat].push(items[i]);
						}
					});						
					
				}
				catch (error){
					
					console.warn('Bad custom icons JSON');
				}
				

			}
			
			
			// add icons
			if($add_icons != undefined){
	
				var $addIconsArray = JSON.parse($add_icons);
					
				if($addIconsArray !=''){
					$.each($addIconsArray,function(cat,items){
						
						if(thz_icons_list[cat] ==  undefined){
							thz_icons_list[cat] =[];
						}
						
						for (var i = 0; i < items.length; i++) {
							thz_icons_list[cat].push(items[i]);
						}
					});
				}
			}
			
			// remove icons 
			
			if($remove_icons != undefined){
				
				var $removeIconsArray = JSON.parse($remove_icons);
				if($removeIconsArray !=''){
					$.each(thz_icons_list,function(cat,items){
						
						$.each($removeIconsArray,function(i,icon){
							var index = thz_icons_list[cat].indexOf(icon);
							if (index > -1) {
								thz_icons_list[cat].splice(index, 1);
							}				
						});
		
					});
				}
	
			}
			
			// remove categories 
			if($remove_categories != undefined){
				
				var $removeCatsArray = JSON.parse($remove_categories);
				if($removeCatsArray !=''){
	
					for (var i=0; i < $removeCatsArray.length; i++){
						
						delete thz_icons_list[$removeCatsArray[i]];
					}
				}
			}
			
			
			// specific categories
			
			if($categories != undefined){
				
				var $CatsArray = JSON.parse($categories);
				
				if($CatsArray !=''){
						
					var kept = {};
					for (var i=0; i < $CatsArray.length; i++){
						kept[$CatsArray[i]] = thz_icons_list[$CatsArray[i]];
					}
					
					thz_icons_list = kept;
				}
			}		
			
			
				
			var $thz_icon_picker = $iconsholder.fontIconPicker({
				theme				: 'fip-grey',
				source				: thz_icons_list,
				allCategoryText		:'All icon sets',
				searchSource		: thz_icons_search_list,
				appendTo          	: 'self',
			});
				
			
			var $current 	= $iconsholder.val();
			var $selected  	= $element.find('.selected-icon i');
			var $trigger	= $element.find('.selector-button');
			var $category	= $element.find('.icon-category-select');
			
			
			if($current !=''){
				$icon_name.attr('title',$current);
			}
			$iconsholder.on('change', function(e) {
				 var $val = $(this).val();
				 
				 if($val !=''){
					$icon_name.attr('title',$val);
				 }else{
					 $icon_name.attr('title','Select an icon to see the class name');
				 }
				 
				// $(event.target).closest('.field-mega-menu-icon').find('input').val(values.icon).change();
			});



		}).addClass('thz-option-initialized');
	});

})(jQuery, fwEvents);





var $customIconSet;


var thz_icon_source ={"Thz Icons ( 16px grid )":["thzicon thzicon-themezly","thzicon thzicon-creatus","thzicon thzicon-zap","thzicon thzicon-scissors","thzicon thzicon-avira-antivirus","thzicon thzicon-gallery","thzicon thzicon-desktop","thzicon thzicon-eye4","thzicon thzicon-paper-clip2","thzicon thzicon-mail7","thzicon thzicon-toggle","thzicon thzicon-toggle-off","thzicon thzicon-layout","thzicon thzicon-link5","thzicon thzicon-bell3","thzicon thzicon-lock5","thzicon thzicon-unlock","thzicon thzicon-ribbon2","thzicon thzicon-image2","thzicon thzicon-signal2","thzicon thzicon-target3","thzicon thzicon-clipboard3","thzicon thzicon-clock5","thzicon thzicon-watch","thzicon thzicon-air-play","thzicon thzicon-camera3","thzicon thzicon-video2","thzicon thzicon-disc","thzicon thzicon-printer4","thzicon thzicon-monitor","thzicon thzicon-server2","thzicon thzicon-cog4","thzicon thzicon-heart5","thzicon thzicon-paragraph","thzicon thzicon-align-justify","thzicon thzicon-align-left","thzicon thzicon-align-center","thzicon thzicon-align-right","thzicon thzicon-book3","thzicon thzicon-layers2","thzicon thzicon-stack2","thzicon thzicon-stack-2","thzicon thzicon-paper","thzicon thzicon-paper-stack","thzicon thzicon-search5","thzicon thzicon-zoom-in3","thzicon thzicon-zoom-out3","thzicon thzicon-reply2","thzicon thzicon-circle-plus","thzicon thzicon-circle-minus","thzicon thzicon-circle-check","thzicon thzicon-circle-cross","thzicon thzicon-square-plus","thzicon thzicon-square-minus","thzicon thzicon-square-check","thzicon thzicon-square-cross","thzicon thzicon-microphone","thzicon thzicon-record","thzicon thzicon-skip-back","thzicon thzicon-rewind","thzicon thzicon-play4","thzicon thzicon-pause3","thzicon thzicon-stop4","thzicon thzicon-fast-forward","thzicon thzicon-skip-forward","thzicon thzicon-shuffle2","thzicon thzicon-repeat","thzicon thzicon-folder2","thzicon thzicon-umbrella3","thzicon thzicon-moon","thzicon thzicon-thermometer","thzicon thzicon-drop2","thzicon thzicon-sun4","thzicon thzicon-cloud5","thzicon thzicon-cloud-upload3","thzicon thzicon-cloud-download3","thzicon thzicon-upload5","thzicon thzicon-download5","thzicon thzicon-location4","thzicon thzicon-location-2","thzicon thzicon-map4","thzicon thzicon-battery2","thzicon thzicon-head","thzicon thzicon-briefcase6","thzicon thzicon-speech-bubble2","thzicon thzicon-anchor3","thzicon thzicon-globe4","thzicon thzicon-box2","thzicon thzicon-reload","thzicon thzicon-share3","thzicon thzicon-marquee","thzicon thzicon-marquee-plus","thzicon thzicon-marquee-minus","thzicon thzicon-tag2","thzicon thzicon-power2","thzicon thzicon-command2","thzicon thzicon-alt","thzicon thzicon-esc","thzicon thzicon-bar-graph","thzicon thzicon-bar-graph-2","thzicon thzicon-pie-graph","thzicon thzicon-star4","thzicon thzicon-arrow-left5","thzicon thzicon-arrow-right5","thzicon thzicon-arrow-up5","thzicon thzicon-arrow-down5","thzicon thzicon-volume","thzicon thzicon-mute2","thzicon thzicon-content-right","thzicon thzicon-content-left","thzicon thzicon-grid2","thzicon thzicon-grid-2","thzicon thzicon-columns","thzicon thzicon-loader","thzicon thzicon-bag","thzicon thzicon-ban","thzicon thzicon-flag3","thzicon thzicon-trash2","thzicon thzicon-expand2","thzicon thzicon-contract","thzicon thzicon-maximize","thzicon thzicon-minimize","thzicon thzicon-plus3","thzicon thzicon-minus2","thzicon thzicon-check2","thzicon thzicon-cross2","thzicon thzicon-move","thzicon thzicon-delete","thzicon thzicon-menu5","thzicon thzicon-box-time-o","thzicon thzicon-box-lock-o","thzicon thzicon-box-check-o","thzicon thzicon-archive","thzicon thzicon-inbox2","thzicon thzicon-outbox","thzicon thzicon-file2","thzicon thzicon-file-add","thzicon thzicon-file-subtract","thzicon thzicon-help","thzicon thzicon-open","thzicon thzicon-global-delivery-check","thzicon thzicon-shopping-cart-delivery","thzicon thzicon-shopping-cart-check","thzicon thzicon-shopping-cart-time","thzicon thzicon-hand-free","thzicon thzicon-map-marker","thzicon thzicon-codeguard","thzicon thzicon-purse-time","thzicon thzicon-purse-check","thzicon thzicon-crown","thzicon thzicon-toggle-on","thzicon thzicon-heart3","thzicon thzicon-camera-diaphragm","thzicon thzicon-chat","thzicon thzicon-box-check","thzicon thzicon-box-arrow","thzicon thzicon-cup","thzicon thzicon-ellipsis3","thzicon thzicon-list-ul","thzicon thzicon-envelope-open","thzicon thzicon-tooltip","thzicon thzicon-photo-camera","thzicon thzicon-apple","thzicon thzicon-tag-check","thzicon thzicon-tag-empty","thzicon thzicon-tag-new","thzicon thzicon-price-tag-usd","thzicon thzicon-tag-percent","thzicon thzicon-label-circle","thzicon thzicon-shopping-cart","thzicon thzicon-shopping-cart-full","thzicon thzicon-shopping-cart-full2","thzicon thzicon-shopping-cart-plus","thzicon thzicon-shopping-cart-minus","thzicon thzicon-shopping-cart2","thzicon thzicon-shopping-cart3","thzicon thzicon-credit-cards","thzicon thzicon-check-circle-o2","thzicon thzicon-piggy-bank","thzicon thzicon-wallet","thzicon thzicon-box","thzicon thzicon-money","thzicon thzicon-coins","thzicon thzicon-gift","thzicon thzicon-desert","thzicon thzicon-question-circle","thzicon thzicon-box-upload","thzicon thzicon-coffee","thzicon thzicon-store","thzicon thzicon-certificate","thzicon thzicon-clothes-women","thzicon thzicon-shoes-women","thzicon thzicon-hat-women","thzicon thzicon-skirt","thzicon thzicon-shoes-women2","thzicon thzicon-cog","thzicon thzicon-cocktail","thzicon thzicon-delete-circle","thzicon thzicon-box-open","thzicon thzicon-cogs","thzicon thzicon-cogs2","thzicon thzicon-cog2","thzicon thzicon-paper-clip","thzicon thzicon-lightning","thzicon thzicon-list","thzicon thzicon-link","thzicon thzicon-tools","thzicon thzicon-brush","thzicon thzicon-wrench","thzicon thzicon-hammer","thzicon thzicon-wifi","thzicon thzicon-dashboard","thzicon thzicon-broken-link","thzicon thzicon-pin","thzicon thzicon-light-bulb","thzicon thzicon-pen-ruler","thzicon thzicon-minus-circle","thzicon thzicon-pizza","thzicon thzicon-medal","thzicon thzicon-chess","thzicon thzicon-scissors1","thzicon thzicon-tool-square","thzicon thzicon-tool-square2","thzicon thzicon-tool-square3","thzicon thzicon-tool-square4","thzicon thzicon-tool-square5","thzicon thzicon-tool-circle","thzicon thzicon-tool-double-square","thzicon thzicon-tool-double-square2","thzicon thzicon-coffee2","thzicon thzicon-restaurant","thzicon thzicon-tool-double-square3","thzicon thzicon-tool-crop","thzicon thzicon-tool-square6","thzicon thzicon-tool-color-sample","thzicon thzicon-tool-color-sample2","thzicon thzicon-tool-brush","thzicon thzicon-tool-brush-arrow","thzicon thzicon-tool-pen","thzicon thzicon-arrow-mouse","thzicon thzicon-screwdriver","thzicon thzicon-rosted-chicken","thzicon thzicon-not-allowed","thzicon thzicon-pencil","thzicon thzicon-tool-dodge","thzicon thzicon-tool-blur","thzicon thzicon-tool-clone-stamp","thzicon thzicon-tool-pattern-stamp","thzicon thzicon-tool-move","thzicon thzicon-tool-magic-wand","thzicon thzicon-tool-paint-bucket","thzicon thzicon-tool-content-move","thzicon thzicon-tool-ruler","thzicon thzicon-crab","thzicon thzicon-printer","thzicon thzicon-flag-eu","thzicon thzicon-rectangle","thzicon thzicon-two-windows","thzicon thzicon-text-letter","thzicon thzicon-text-letter-height","thzicon thzicon-text-letter-scale","thzicon thzicon-eye","thzicon thzicon-document-check","thzicon thzicon-coffee3","thzicon thzicon-scanner","thzicon thzicon-magnifying-glass","thzicon thzicon-document-plus","thzicon thzicon-document-delete","thzicon thzicon-document-minus","thzicon thzicon-document-info","thzicon thzicon-document-warning","thzicon thzicon-document-question","thzicon thzicon-document-arrow","thzicon thzicon-document-stamp","thzicon thzicon-speech-bubble","thzicon thzicon-speech-bubble-waiting","thzicon thzicon-restaurant-plate","thzicon thzicon-bell2","thzicon thzicon-spinner","thzicon thzicon-kat","thzicon thzicon-martini","thzicon thzicon-light-bulb2","thzicon thzicon-crop","thzicon thzicon-hospital-plus","thzicon thzicon-speech-bubble-text","thzicon thzicon-email-open","thzicon thzicon-pie-chart","thzicon thzicon-speech-bubbles","thzicon thzicon-twitter","thzicon thzicon-facebook","thzicon thzicon-twitter2","thzicon thzicon-google-plus","thzicon thzicon-rss","thzicon thzicon-pencil2","thzicon thzicon-ellipsis","thzicon thzicon-orange","thzicon thzicon-check-circle","thzicon thzicon-bars","thzicon thzicon-user-rss","thzicon thzicon-user-check","thzicon thzicon-user-plus","thzicon thzicon-user-delete","thzicon thzicon-user-minus","thzicon thzicon-user-info","thzicon thzicon-user-warning","thzicon thzicon-user-question","thzicon thzicon-user-arrow","thzicon thzicon-food-plate","thzicon thzicon-star2","thzicon thzicon-cloud","thzicon thzicon-diamond","thzicon thzicon-unyson","thzicon thzicon-original","thzicon thzicon-briefcase","thzicon thzicon-bar-chart","thzicon thzicon-master-card","thzicon thzicon-visa","thzicon thzicon-line-chart","thzicon thzicon-safe","thzicon thzicon-bank","thzicon thzicon-wine-bottle","thzicon thzicon-battery-full-h","thzicon thzicon-dollar-bill","thzicon thzicon-calendar","thzicon thzicon-calendar-check","thzicon thzicon-sound","thzicon thzicon-battery-half","thzicon thzicon-pie-chart2","thzicon thzicon-battery-low","thzicon thzicon-light-bulb3","thzicon thzicon-heart","thzicon thzicon-drawers","thzicon thzicon-database","thzicon thzicon-handshake","thzicon thzicon-hot-drink","thzicon thzicon-cherries","thzicon thzicon-battery-low-h","thzicon thzicon-business-woman","thzicon thzicon-business-man","thzicon thzicon-pencil3","thzicon thzicon-user-promotion","thzicon thzicon-user-structure","thzicon thzicon-user-graph","thzicon thzicon-office-chair","thzicon thzicon-clipboard-check","thzicon thzicon-notebook","thzicon thzicon-notebook-check","thzicon thzicon-battery-full","thzicon thzicon-plug","thzicon thzicon-heart-rate","thzicon thzicon-event","thzicon thzicon-megaphone","thzicon thzicon-battery","thzicon thzicon-socket","thzicon thzicon-heart-plus","thzicon thzicon-event-phone","thzicon thzicon-event-star","thzicon thzicon-event-check","thzicon thzicon-event-delete","thzicon thzicon-event-plus","thzicon thzicon-event-minus","thzicon thzicon-event-at","thzicon thzicon-event-edit","thzicon thzicon-event-time","thzicon thzicon-accumulator","thzicon thzicon-trompete2","thzicon thzicon-event-cog","thzicon thzicon-event-arrow","thzicon thzicon-event-location","thzicon thzicon-event-heart","thzicon thzicon-event-gift","thzicon thzicon-event-music","thzicon thzicon-event-warning","thzicon thzicon-toxic","thzicon thzicon-hand-stop","thzicon thzicon-star-check","thzicon thzicon-star-plus","thzicon thzicon-star-delete","thzicon thzicon-plane","thzicon thzicon-arrow-right-top","thzicon thzicon-stop-sign","thzicon thzicon-star","thzicon thzicon-butterfly-bow","thzicon thzicon-24h","thzicon thzicon-event-checklist","thzicon thzicon-event-progress","thzicon thzicon-bluetooth","thzicon thzicon-arrow-left-bottom","thzicon thzicon-sparkle","thzicon thzicon-cake","thzicon thzicon-hot-coffee","thzicon thzicon-free-tag","thzicon thzicon-arrow-right-bottom","thzicon thzicon-free-download","thzicon thzicon-free-upload","thzicon thzicon-free-mail","thzicon thzicon-free-phone","thzicon thzicon-free-coffee","thzicon thzicon-free-photo","thzicon thzicon-free-gift","thzicon thzicon-free-video","thzicon thzicon-arrow-left-top","thzicon thzicon-worker","thzicon thzicon-free-arrow","thzicon thzicon-free-barcode","thzicon thzicon-free-shopping","thzicon thzicon-free-message","thzicon thzicon-free-wifi","thzicon thzicon-eating-utensils","thzicon thzicon-signal","thzicon thzicon-free-event","thzicon thzicon-free-sign","thzicon thzicon-free-mobile","thzicon thzicon-diamond2","thzicon thzicon-diamond-o","thzicon thzicon-star-circle","thzicon thzicon-hair-styling","thzicon thzicon-musical-note","thzicon thzicon-bow-tie","thzicon thzicon-bow-tie2","thzicon thzicon-shirt-hanger","thzicon thzicon-scissors2","thzicon thzicon-pants","thzicon thzicon-tshirt2","thzicon thzicon-tshirt2-o","thzicon thzicon-mannequin","thzicon thzicon-beer","thzicon thzicon-umbrella","thzicon thzicon-moustache","thzicon thzicon-angle-up2","thzicon thzicon-angle-right2","thzicon thzicon-angle-down2","thzicon thzicon-angle-left2","thzicon thzicon-arrow-up","thzicon thzicon-arrow-right","thzicon thzicon-arrow-down","thzicon thzicon-arrow-left","thzicon thzicon-bus","thzicon thzicon-comment-o","thzicon thzicon-direction-left","thzicon thzicon-direction-right","thzicon thzicon-intersection-left","thzicon thzicon-intersection-right","thzicon thzicon-map-marker2","thzicon thzicon-map-marker-star","thzicon thzicon-map-marker-circle","thzicon thzicon-comment-half","thzicon thzicon-map","thzicon thzicon-target-location","thzicon thzicon-see-side","thzicon thzicon-cake2","thzicon thzicon-comment","thzicon thzicon-arrows-both-ways","thzicon thzicon-map-tracking","thzicon thzicon-marker-parking","thzicon thzicon-marker-hospital","thzicon thzicon-house","thzicon thzicon-house2","thzicon thzicon-cabin","thzicon thzicon-house3","thzicon thzicon-house4","thzicon thzicon-building","thzicon thzicon-building3","thzicon thzicon-soda","thzicon thzicon-musical-key","thzicon thzicon-building5","thzicon thzicon-building6","thzicon thzicon-house5","thzicon thzicon-house6","thzicon thzicon-house-search","thzicon thzicon-sales-woman","thzicon thzicon-landlord","thzicon thzicon-sold-sign","thzicon thzicon-upload","thzicon thzicon-rent-sign","thzicon thzicon-sale-sign","thzicon thzicon-house-search2","thzicon thzicon-sales-man","thzicon thzicon-rent-sale","thzicon thzicon-cross-square","thzicon thzicon-download","thzicon thzicon-head-phones","thzicon thzicon-unyson-o","thzicon thzicon-home5","thzicon thzicon-home22","thzicon thzicon-home3","thzicon thzicon-office","thzicon thzicon-newspaper2","thzicon thzicon-key2","thzicon thzicon-pencil7","thzicon thzicon-cross-square-o","thzicon thzicon-stop-circle","thzicon thzicon-pencil22","thzicon thzicon-money-bag","thzicon thzicon-head-phones1","thzicon thzicon-quill","thzicon thzicon-pen","thzicon thzicon-blog","thzicon thzicon-eyedropper","thzicon thzicon-droplet","thzicon thzicon-house8","thzicon thzicon-house9","thzicon thzicon-paint-format","thzicon thzicon-image","thzicon thzicon-images","thzicon thzicon-minus-circle2","thzicon thzicon-camera2","thzicon thzicon-headphones2","thzicon thzicon-music2","thzicon thzicon-play","thzicon thzicon-film","thzicon thzicon-video-camera","thzicon thzicon-dice","thzicon thzicon-pacman","thzicon thzicon-spades","thzicon thzicon-clubs","thzicon thzicon-diamonds","thzicon thzicon-bullhorn","thzicon thzicon-connection","thzicon thzicon-podcast","thzicon thzicon-drop","thzicon thzicon-plus-circle","thzicon thzicon-feed","thzicon thzicon-mic3","thzicon thzicon-book2","thzicon thzicon-books","thzicon thzicon-library","thzicon thzicon-file-text3","thzicon thzicon-profile","thzicon thzicon-file-empty","thzicon thzicon-files-empty","thzicon thzicon-file-text2","thzicon thzicon-peace-circle","thzicon thzicon-ying-yang","thzicon thzicon-file-picture","thzicon thzicon-first-aid-kit","thzicon thzicon-check-circle-o","thzicon thzicon-darts","thzicon thzicon-file-music","thzicon thzicon-file-play","thzicon thzicon-file-video","thzicon thzicon-file-zip2","thzicon thzicon-copy","thzicon thzicon-paste","thzicon thzicon-stack","thzicon thzicon-folder","thzicon thzicon-pigeon","thzicon thzicon-folder-open","thzicon thzicon-folder-plus","thzicon thzicon-folder-minus","thzicon thzicon-folder-download","thzicon thzicon-folder-upload","thzicon thzicon-delete-circle2","thzicon thzicon-price-tag","thzicon thzicon-price-tags","thzicon thzicon-barcode","thzicon thzicon-qrcode","thzicon thzicon-ticket","thzicon thzicon-cart","thzicon thzicon-coin-dollar","thzicon thzicon-coin-euro","thzicon thzicon-coin-pound","thzicon thzicon-coin-yen","thzicon thzicon-credit-card2","thzicon thzicon-lifebuoy","thzicon thzicon-phone2","thzicon thzicon-eye-dropper","thzicon thzicon-phone-hang-up","thzicon thzicon-address-book","thzicon thzicon-envelop","thzicon thzicon-pushpin","thzicon thzicon-location3","thzicon thzicon-location2","thzicon thzicon-compass3","thzicon thzicon-compass2","thzicon thzicon-map3","thzicon thzicon-map22","thzicon thzicon-history2","thzicon thzicon-clock4","thzicon thzicon-clock22","thzicon thzicon-alarm","thzicon thzicon-bell","thzicon thzicon-stopwatch","thzicon thzicon-info-circle","thzicon thzicon-go","thzicon thzicon-calendar4","thzicon thzicon-printer3","thzicon thzicon-usd-circle","thzicon thzicon-euro-circle","thzicon thzicon-pound-circle","thzicon thzicon-yen-circle","thzicon thzicon-rouble-circle","thzicon thzicon-bitcoin-circle","thzicon thzicon-lira-circle","thzicon thzicon-rupee-circle","thzicon thzicon-display","thzicon thzicon-laptop2","thzicon thzicon-mobile3","thzicon thzicon-warning-circle","thzicon thzicon-mobile22","thzicon thzicon-tablet2","thzicon thzicon-tv","thzicon thzicon-shekel-circle","thzicon thzicon-rand-circle","thzicon thzicon-usd","thzicon thzicon-euro","thzicon thzicon-pound","thzicon thzicon-yen","thzicon thzicon-rouble","thzicon thzicon-bitcoin","thzicon thzicon-lira","thzicon thzicon-rupee","thzicon thzicon-drawer","thzicon thzicon-stethoscope","thzicon thzicon-power-off","thzicon thzicon-drawer2","thzicon thzicon-syringe","thzicon thzicon-play-circle","thzicon thzicon-usd-exchange","thzicon thzicon-euro-exchange","thzicon thzicon-pound-exchange","thzicon thzicon-yen-exchange","thzicon thzicon-box-add","thzicon thzicon-box-remove","thzicon thzicon-clock","thzicon thzicon-download4","thzicon thzicon-key","thzicon thzicon-upload4","thzicon thzicon-floppy-disk","thzicon thzicon-drive","thzicon thzicon-database3","thzicon thzicon-undo","thzicon thzicon-redo","thzicon thzicon-undo2","thzicon thzicon-redo2","thzicon thzicon-forward","thzicon thzicon-reply","thzicon thzicon-bubble","thzicon thzicon-bubbles","thzicon thzicon-bubbles2","thzicon thzicon-bubble2","thzicon thzicon-bubbles3","thzicon thzicon-bubbles4","thzicon thzicon-user","thzicon thzicon-users","thzicon thzicon-user-plus2","thzicon thzicon-user-minus2","thzicon thzicon-user-check2","thzicon thzicon-user-tie","thzicon thzicon-quotes-left","thzicon thzicon-quotes-right","thzicon thzicon-hour-glass","thzicon thzicon-spinner12","thzicon thzicon-spinner2","thzicon thzicon-spinner3","thzicon thzicon-spinner4","thzicon thzicon-spinner5","thzicon thzicon-spinner6","thzicon thzicon-spinner7","thzicon thzicon-spinner8","thzicon thzicon-spinner9","thzicon thzicon-spinner10","thzicon thzicon-spinner11","thzicon thzicon-binoculars","thzicon thzicon-search4","thzicon thzicon-zoom-in2","thzicon thzicon-zoom-out2","thzicon thzicon-enlarge","thzicon thzicon-shrink","thzicon thzicon-enlarge2","thzicon thzicon-shrink2","thzicon thzicon-key6","thzicon thzicon-key22","thzicon thzicon-lock4","thzicon thzicon-unlocked","thzicon thzicon-wrench3","thzicon thzicon-equalizer3","thzicon thzicon-equalizer2","thzicon thzicon-cog3","thzicon thzicon-cogs3","thzicon thzicon-hammer3","thzicon thzicon-magic-wand","thzicon thzicon-aid-kit","thzicon thzicon-bug2","thzicon thzicon-pie-chart3","thzicon thzicon-stats-dots","thzicon thzicon-stats-bars","thzicon thzicon-stats-bars2","thzicon thzicon-trophy2","thzicon thzicon-gift5","thzicon thzicon-glass","thzicon thzicon-glass2","thzicon thzicon-mug","thzicon thzicon-spoon-knife","thzicon thzicon-leaf","thzicon thzicon-rocket2","thzicon thzicon-meter","thzicon thzicon-meter2","thzicon thzicon-hammer2","thzicon thzicon-fire","thzicon thzicon-lab","thzicon thzicon-magnet","thzicon thzicon-bin","thzicon thzicon-bin2","thzicon thzicon-briefcase5","thzicon thzicon-airplane","thzicon thzicon-truck","thzicon thzicon-road","thzicon thzicon-accessibility","thzicon thzicon-target2","thzicon thzicon-shield2","thzicon thzicon-power","thzicon thzicon-switch","thzicon thzicon-power-cord","thzicon thzicon-clipboard2","thzicon thzicon-list-numbered","thzicon thzicon-list3","thzicon thzicon-list2","thzicon thzicon-tree","thzicon thzicon-menu","thzicon thzicon-menu2","thzicon thzicon-menu3","thzicon thzicon-menu4","thzicon thzicon-cloud4","thzicon thzicon-cloud-download2","thzicon thzicon-cloud-upload2","thzicon thzicon-joystick2","thzicon thzicon-cloud-check","thzicon thzicon-download22","thzicon thzicon-upload22","thzicon thzicon-caduceus","thzicon thzicon-download3","thzicon thzicon-pages-up","thzicon thzicon-music-volume","thzicon thzicon-usd-bills","thzicon thzicon-euro-bills","thzicon thzicon-pound-bills","thzicon thzicon-yen-bills","thzicon thzicon-upload3","thzicon thzicon-syringe2","thzicon thzicon-sphere","thzicon thzicon-earth","thzicon thzicon-pages-down","thzicon thzicon-music-volume-off","thzicon thzicon-credit-cards2","thzicon thzicon-cash-bag2","thzicon thzicon-link4","thzicon thzicon-flag2","thzicon thzicon-attachment2","thzicon thzicon-eye3","thzicon thzicon-eye-plus","thzicon thzicon-music-volume-off2","thzicon thzicon-eye-minus","thzicon thzicon-currency-bill","thzicon thzicon-eye-blocked","thzicon thzicon-bank2","thzicon thzicon-usd-circle-o","thzicon thzicon-bookmark2","thzicon thzicon-bookmarks","thzicon thzicon-business-stats","thzicon thzicon-money-stack","thzicon thzicon-sun3","thzicon thzicon-nurse","thzicon thzicon-contrast","thzicon thzicon-anchor","thzicon thzicon-brightness-contrast","thzicon thzicon-ipod","thzicon thzicon-safe-case","thzicon thzicon-star-empty","thzicon thzicon-star-half","thzicon thzicon-star-full","thzicon thzicon-ambulance","thzicon thzicon-gears","thzicon thzicon-heart4","thzicon thzicon-heart-broken","thzicon thzicon-music-volume-bars","thzicon thzicon-clepsydra","thzicon thzicon-presentation-board","thzicon thzicon-man2","thzicon thzicon-woman2","thzicon thzicon-man-woman","thzicon thzicon-pie-chart22","thzicon thzicon-happy3","thzicon thzicon-happy2","thzicon thzicon-percentage-circle","thzicon thzicon-smile","thzicon thzicon-smile2","thzicon thzicon-tooth","thzicon thzicon-wrench2","thzicon thzicon-zoom-out","thzicon thzicon-tongue","thzicon thzicon-tongue2","thzicon thzicon-sad3","thzicon thzicon-usd-exchange2","thzicon thzicon-sad2","thzicon thzicon-cash-register","thzicon thzicon-tag-o","thzicon thzicon-money-stack2","thzicon thzicon-tag-usd","thzicon thzicon-wink","thzicon thzicon-wink2","thzicon thzicon-sharing","thzicon thzicon-zoom-in","thzicon thzicon-gift2","thzicon thzicon-grin","thzicon thzicon-grin2","thzicon thzicon-cool","thzicon thzicon-laptop-graph","thzicon thzicon-angry","thzicon thzicon-angry2","thzicon thzicon-evil","thzicon thzicon-evil2","thzicon thzicon-shocked","thzicon thzicon-lightning2","thzicon thzicon-shocked2","thzicon thzicon-baffled","thzicon thzicon-zoom","thzicon thzicon-baffled2","thzicon thzicon-confused","thzicon thzicon-cloud-rain","thzicon thzicon-snow","thzicon thzicon-rain-snow","thzicon thzicon-cloud-lightning","thzicon thzicon-sun-cloud","thzicon thzicon-cloud2","thzicon thzicon-sun","thzicon thzicon-sun2","thzicon thzicon-sun-o","thzicon thzicon-clouds","thzicon thzicon-confused2","thzicon thzicon-neutral","thzicon thzicon-wifi2","thzicon thzicon-neutral2","thzicon thzicon-auction-hammer","thzicon thzicon-hipster","thzicon thzicon-hipster2","thzicon thzicon-wondering","thzicon thzicon-wondering2","thzicon thzicon-sleepy","thzicon thzicon-sleepy2","thzicon thzicon-frustrated","thzicon thzicon-frustrated2","thzicon thzicon-crying","thzicon thzicon-crying2","thzicon thzicon-point-up","thzicon thzicon-point-right","thzicon thzicon-point-down","thzicon thzicon-point-left","thzicon thzicon-warning2","thzicon thzicon-notification","thzicon thzicon-plus2","thzicon thzicon-minus","thzicon thzicon-info2","thzicon thzicon-cancel-circle","thzicon thzicon-blocked","thzicon thzicon-cross","thzicon thzicon-checkmark","thzicon thzicon-checkmark2","thzicon thzicon-spell-check","thzicon thzicon-enter","thzicon thzicon-exit","thzicon thzicon-play2","thzicon thzicon-pause","thzicon thzicon-stop3","thzicon thzicon-previous","thzicon thzicon-next","thzicon thzicon-backward","thzicon thzicon-forward2","thzicon thzicon-play3","thzicon thzicon-pause2","thzicon thzicon-stop2","thzicon thzicon-backward2","thzicon thzicon-forward3","thzicon thzicon-first","thzicon thzicon-last","thzicon thzicon-previous2","thzicon thzicon-next2","thzicon thzicon-eject","thzicon thzicon-volume-high","thzicon thzicon-volume-medium","thzicon thzicon-volume-low","thzicon thzicon-volume-mute","thzicon thzicon-volume-mute2","thzicon thzicon-volume-increase","thzicon thzicon-volume-decrease","thzicon thzicon-loop","thzicon thzicon-loop2","thzicon thzicon-infinite","thzicon thzicon-shuffle","thzicon thzicon-arrow-up-left","thzicon thzicon-arrow-up4","thzicon thzicon-arrow-up-right","thzicon thzicon-arrow-right4","thzicon thzicon-arrow-down-right","thzicon thzicon-arrow-down4","thzicon thzicon-arrow-down-left","thzicon thzicon-arrow-left4","thzicon thzicon-arrow-up-left2","thzicon thzicon-arrow-up2","thzicon thzicon-arrow-up-right2","thzicon thzicon-arrow-right2","thzicon thzicon-arrow-down-right2","thzicon thzicon-arrow-down2","thzicon thzicon-arrow-down-left2","thzicon thzicon-arrow-left2","thzicon thzicon-circle-up","thzicon thzicon-circle-right","thzicon thzicon-circle-down","thzicon thzicon-circle-left","thzicon thzicon-tab","thzicon thzicon-move-up2","thzicon thzicon-move-down2","thzicon thzicon-sort-alpha-asc","thzicon thzicon-sort-alpha-desc","thzicon thzicon-sort-numeric-asc","thzicon thzicon-sort-numberic-desc","thzicon thzicon-sort-amount-asc","thzicon thzicon-sort-amount-desc","thzicon thzicon-command","thzicon thzicon-shift","thzicon thzicon-ctrl","thzicon thzicon-opt","thzicon thzicon-checkbox-checked","thzicon thzicon-checkbox-unchecked","thzicon thzicon-radio-checked","thzicon thzicon-radio-checked2","thzicon thzicon-radio-unchecked","thzicon thzicon-crop2","thzicon thzicon-night","thzicon thzicon-night-snow","thzicon thzicon-night-lightning","thzicon thzicon-umbrella2","thzicon thzicon-scissors4","thzicon thzicon-filter","thzicon thzicon-moon2","thzicon thzicon-moon-phase","thzicon thzicon-moon-phase2","thzicon thzicon-font","thzicon thzicon-ligature","thzicon thzicon-trash","thzicon thzicon-ligature2","thzicon thzicon-hand","thzicon thzicon-music-notes","thzicon thzicon-rain2","thzicon thzicon-text-height","thzicon thzicon-text-width","thzicon thzicon-font-size","thzicon thzicon-bold","thzicon thzicon-underline","thzicon thzicon-snow2","thzicon thzicon-sun-rain","thzicon thzicon-sun-snow","thzicon thzicon-rainbow","thzicon thzicon-italic","thzicon thzicon-pencil4","thzicon thzicon-strikethrough","thzicon thzicon-omega","thzicon thzicon-sigma","thzicon thzicon-page-break","thzicon thzicon-superscript","thzicon thzicon-na","thzicon thzicon-subscript","thzicon thzicon-superscript2","thzicon thzicon-subscript2","thzicon thzicon-text-color","thzicon thzicon-pagebreak","thzicon thzicon-clear-formatting","thzicon thzicon-insert-template","thzicon thzicon-pilcrow","thzicon thzicon-ltr","thzicon thzicon-home","thzicon thzicon-rtl","thzicon thzicon-cloud-rain3","thzicon thzicon-snow22","thzicon thzicon-rain-snow2","thzicon thzicon-sun-cloud2","thzicon thzicon-night2","thzicon thzicon-section","thzicon thzicon-paragraph-left","thzicon thzicon-home2","thzicon thzicon-id-card","thzicon thzicon-paragraph-center","thzicon thzicon-paragraph-right","thzicon thzicon-hospital-square","thzicon thzicon-file-edit","thzicon thzicon-paragraph-justify","thzicon thzicon-indent-increase","thzicon thzicon-mechanical-pen","thzicon thzicon-indent-decrease","thzicon thzicon-edit-card","thzicon thzicon-presentation-board3","thzicon thzicon-share","thzicon thzicon-new-tab","thzicon thzicon-embed","thzicon thzicon-embed2","thzicon thzicon-terminal2","thzicon thzicon-share2","thzicon thzicon-file-word","thzicon thzicon-mobile","thzicon thzicon-slider","thzicon thzicon-google-plus2","thzicon thzicon-google-plus3","thzicon thzicon-google-drive","thzicon thzicon-briefcase2","thzicon thzicon-facebook4","thzicon thzicon-hospital-marker-h","thzicon thzicon-facebook22","thzicon thzicon-facebook3","thzicon thzicon-footprint","thzicon thzicon-ello","thzicon thzicon-instagram","thzicon thzicon-twitter5","thzicon thzicon-plus-circle-o","thzicon thzicon-twitter22","thzicon thzicon-twitter32","thzicon thzicon-feed2","thzicon thzicon-feed3","thzicon thzicon-feed4","thzicon thzicon-youtube5","thzicon thzicon-youtube2","thzicon thzicon-youtube3","thzicon thzicon-mobile-user","thzicon thzicon-vimeo4","thzicon thzicon-vimeo2","thzicon thzicon-vimeo3","thzicon thzicon-mail","thzicon thzicon-flickr","thzicon thzicon-flickr2","thzicon thzicon-flickr3","thzicon thzicon-flickr4","thzicon thzicon-picassa","thzicon thzicon-picassa2","thzicon thzicon-dribbble4","thzicon thzicon-dribbble2","thzicon thzicon-dribbble3","thzicon thzicon-playlist","thzicon thzicon-controls2","thzicon thzicon-rent","thzicon thzicon-sold","thzicon thzicon-deviantart","thzicon thzicon-deviantart2","thzicon thzicon-steam","thzicon thzicon-steam2","thzicon thzicon-dropbox2","thzicon thzicon-slider2","thzicon thzicon-onedrive","thzicon thzicon-github","thzicon thzicon-github2","thzicon thzicon-github3","thzicon thzicon-github4","thzicon thzicon-github5","thzicon thzicon-wordpress3","thzicon thzicon-key32","thzicon thzicon-wordpress2","thzicon thzicon-rocking-horse","thzicon thzicon-teddy-bear","thzicon thzicon-duck-toy","thzicon thzicon-spintop","thzicon thzicon-joomla","thzicon thzicon-blogger3","thzicon thzicon-file","thzicon thzicon-tumblr3","thzicon thzicon-tumblr2","thzicon thzicon-yahoo2","thzicon thzicon-tux","thzicon thzicon-apple2","thzicon thzicon-finder","thzicon thzicon-android","thzicon thzicon-windows","thzicon thzicon-windows8","thzicon thzicon-soundcloud","thzicon thzicon-soundcloud2","thzicon thzicon-skype","thzicon thzicon-reddit","thzicon thzicon-linkedin3","thzicon thzicon-lastfm","thzicon thzicon-lastfm2","thzicon thzicon-delicious","thzicon thzicon-stumbleupon","thzicon thzicon-stumbleupon2","thzicon thzicon-stackoverflow","thzicon thzicon-pinterest","thzicon thzicon-pinterest2","thzicon thzicon-xing","thzicon thzicon-xing2","thzicon thzicon-flattr","thzicon thzicon-foursquare","thzicon thzicon-paypal","thzicon thzicon-paypal2","thzicon thzicon-paypal3","thzicon thzicon-yelp","thzicon thzicon-html5","thzicon thzicon-html52","thzicon thzicon-css3","thzicon thzicon-git","thzicon thzicon-svg","thzicon thzicon-codepen","thzicon thzicon-chrome2","thzicon thzicon-firefox2","thzicon thzicon-IE","thzicon thzicon-opera","thzicon thzicon-safari2","thzicon thzicon-stroller","thzicon thzicon-milk-bottle","thzicon thzicon-hand-right","thzicon thzicon-gamepad","thzicon thzicon-scale2","thzicon thzicon-gavel","thzicon thzicon-justice-building","thzicon thzicon-search","thzicon thzicon-disabled","thzicon thzicon-comment-remove","thzicon thzicon-hand-left","thzicon thzicon-sheriff-star","thzicon thzicon-aim","thzicon thzicon-lawyer2","thzicon thzicon-mic","thzicon thzicon-license","thzicon thzicon-graduation-hat","thzicon thzicon-lock","thzicon thzicon-mic-off","thzicon thzicon-check-square","thzicon thzicon-ie","thzicon thzicon-chrome","thzicon thzicon-firefox","thzicon thzicon-youtube","thzicon thzicon-app-store","thzicon thzicon-arrows","thzicon thzicon-music","thzicon thzicon-close-square","thzicon thzicon-app-store-circle","thzicon thzicon-safari","thzicon thzicon-windows-store","thzicon thzicon-dropbox","thzicon thzicon-amazon","thzicon thzicon-at","thzicon thzicon-drive-cloud","thzicon thzicon-wikipedia","thzicon thzicon-globe","thzicon thzicon-light-bulb4","thzicon thzicon-repo","thzicon thzicon-repo-forked","thzicon thzicon-repo-push","thzicon thzicon-repo-pull","thzicon thzicon-book","thzicon thzicon-octoface","thzicon thzicon-git-pull-request","thzicon thzicon-mark-github","thzicon thzicon-cloud-download","thzicon thzicon-cloud-upload","thzicon thzicon-gist","thzicon thzicon-file-code","thzicon thzicon-file-text","thzicon thzicon-file-media","thzicon thzicon-file-zip","thzicon thzicon-file-pdf","thzicon thzicon-tag","thzicon thzicon-file-directory","thzicon thzicon-file-submodule","thzicon thzicon-git-commit","thzicon thzicon-git-branch","thzicon thzicon-git-merge","thzicon thzicon-mirror","thzicon thzicon-issue-opened","thzicon thzicon-issue-reopened","thzicon thzicon-issue-closed","thzicon thzicon-star3","thzicon thzicon-comment2","thzicon thzicon-question","thzicon thzicon-alert","thzicon thzicon-search3","thzicon thzicon-gear","thzicon thzicon-radio-tower","thzicon thzicon-tools3","thzicon thzicon-sign-out","thzicon thzicon-rocket","thzicon thzicon-rss3","thzicon thzicon-clippy","thzicon thzicon-sign-in","thzicon thzicon-organization","thzicon thzicon-device-mobile","thzicon thzicon-unfold","thzicon thzicon-check","thzicon thzicon-mail5","thzicon thzicon-mail-read","thzicon thzicon-arrow-up3","thzicon thzicon-arrow-right3","thzicon thzicon-arrow-down3","thzicon thzicon-arrow-left3","thzicon thzicon-pin2","thzicon thzicon-gift4","thzicon thzicon-triangle-left","thzicon thzicon-credit-card","thzicon thzicon-clock3","thzicon thzicon-ruby","thzicon thzicon-key5","thzicon thzicon-eye2","thzicon thzicon-comment-discussion","thzicon thzicon-mail-reply","thzicon thzicon-primitive-dot","thzicon thzicon-primitive-square","thzicon thzicon-device-camera","thzicon thzicon-device-camera-video","thzicon thzicon-pencil6","thzicon thzicon-info","thzicon thzicon-triangle-right","thzicon thzicon-triangle-down","thzicon thzicon-link3","thzicon thzicon-plus","thzicon thzicon-three-bars","thzicon thzicon-code","thzicon thzicon-location","thzicon thzicon-list-unordered","thzicon thzicon-list-ordered","thzicon thzicon-quote2","thzicon thzicon-versions","thzicon thzicon-color-mode","thzicon thzicon-screen-full","thzicon thzicon-screen-normal","thzicon thzicon-calendar3","thzicon thzicon-beer2","thzicon thzicon-lock3","thzicon thzicon-diff-added","thzicon thzicon-diff-removed","thzicon thzicon-diff-modified","thzicon thzicon-diff-renamed","thzicon thzicon-jump-down","thzicon thzicon-jump-up","thzicon thzicon-move-left","thzicon thzicon-chevron-right","thzicon thzicon-bookmark","thzicon thzicon-settings","thzicon thzicon-dashboard2","thzicon thzicon-history","thzicon thzicon-link-external","thzicon thzicon-mute","thzicon thzicon-x","thzicon thzicon-circle-slash","thzicon thzicon-pulse","thzicon thzicon-sync","thzicon thzicon-telescope2","thzicon thzicon-microscope","thzicon thzicon-alignment-align","thzicon thzicon-alignment-unalign","thzicon thzicon-gist-secret","thzicon thzicon-home4","thzicon thzicon-alignment-aligned-to","thzicon thzicon-bug","thzicon thzicon-file-binary","thzicon thzicon-database2","thzicon thzicon-diff-ignored","thzicon thzicon-chevron-up","thzicon thzicon-chevron-down","thzicon thzicon-chevron-left","thzicon thzicon-jump-left","thzicon thzicon-jump-right","thzicon thzicon-move-up","thzicon thzicon-move-down","thzicon thzicon-move-right","thzicon thzicon-triangle-up","thzicon thzicon-git-compare","thzicon thzicon-podium","thzicon thzicon-file-symlink-file","thzicon thzicon-file-symlink-directory","thzicon thzicon-globe3","thzicon thzicon-unmute","thzicon thzicon-playback-pause","thzicon thzicon-playback-rewind","thzicon thzicon-playback-fast-forward","thzicon thzicon-mention","thzicon thzicon-playback-play","thzicon thzicon-puzzle2","thzicon thzicon-package","thzicon thzicon-browser2","thzicon thzicon-split","thzicon thzicon-terminal","thzicon thzicon-dash","thzicon thzicon-fold","thzicon thzicon-inbox","thzicon thzicon-trashcan","thzicon thzicon-paintcan","thzicon thzicon-flame","thzicon thzicon-briefcase4","thzicon thzicon-plug2","thzicon thzicon-circuit-board","thzicon thzicon-law","thzicon thzicon-mortar-board","thzicon thzicon-device-desktop","thzicon thzicon-facebook-social","thzicon thzicon-twitter-social","thzicon thzicon-google-plus-social","thzicon thzicon-pinterest-social","thzicon thzicon-linkedin-social","thzicon thzicon-reddit-social","thzicon thzicon-email-social","thzicon thzicon-dribbble-social","thzicon thzicon-github-social","thzicon thzicon-instagram-social","thzicon thzicon-themezly-outline","thzicon thzicon-creatus-outline","thzicon thzicon-angle-left","thzicon thzicon-angle-right","thzicon thzicon-angle-up","thzicon thzicon-angle-down"],"Fontawesome ( 14px grid )":["fa fa-glass","fa fa-music","fa fa-search","fa fa-envelope-o","fa fa-heart","fa fa-star","fa fa-star-o","fa fa-user","fa fa-film","fa fa-th-large","fa fa-th","fa fa-th-list","fa fa-check","fa fa-remove","fa fa-search-plus","fa fa-search-minus","fa fa-power-off","fa fa-signal","fa fa-gear","fa fa-trash-o","fa fa-home","fa fa-file-o","fa fa-clock-o","fa fa-road","fa fa-download","fa fa-arrow-circle-o-down","fa fa-arrow-circle-o-up","fa fa-inbox","fa fa-play-circle-o","fa fa-rotate-right","fa fa-refresh","fa fa-list-alt","fa fa-lock","fa fa-flag","fa fa-headphones","fa fa-volume-off","fa fa-volume-down","fa fa-volume-up","fa fa-qrcode","fa fa-barcode","fa fa-tag","fa fa-tags","fa fa-book","fa fa-bookmark","fa fa-print","fa fa-camera","fa fa-font","fa fa-bold","fa fa-italic","fa fa-text-height","fa fa-text-width","fa fa-align-left","fa fa-align-center","fa fa-align-right","fa fa-align-justify","fa fa-list","fa fa-dedent","fa fa-indent","fa fa-video-camera","fa fa-photo","fa fa-pencil","fa fa-map-marker","fa fa-adjust","fa fa-tint","fa fa-edit","fa fa-share-square-o","fa fa-check-square-o","fa fa-arrows","fa fa-step-backward","fa fa-fast-backward","fa fa-backward","fa fa-play","fa fa-pause","fa fa-stop","fa fa-forward","fa fa-fast-forward","fa fa-step-forward","fa fa-eject","fa fa-chevron-left","fa fa-chevron-right","fa fa-plus-circle","fa fa-minus-circle","fa fa-times-circle","fa fa-check-circle","fa fa-question-circle","fa fa-info-circle","fa fa-crosshairs","fa fa-times-circle-o","fa fa-check-circle-o","fa fa-ban","fa fa-arrow-left","fa fa-arrow-right","fa fa-arrow-up","fa fa-arrow-down","fa fa-mail-forward","fa fa-expand","fa fa-compress","fa fa-plus","fa fa-minus","fa fa-asterisk","fa fa-exclamation-circle","fa fa-gift","fa fa-leaf","fa fa-fire","fa fa-eye","fa fa-eye-slash","fa fa-warning","fa fa-plane","fa fa-calendar","fa fa-random","fa fa-comment","fa fa-magnet","fa fa-chevron-up","fa fa-chevron-down","fa fa-retweet","fa fa-shopping-cart","fa fa-folder","fa fa-folder-open","fa fa-arrows-v","fa fa-arrows-h","fa fa-bar-chart-o","fa fa-twitter-square","fa fa-facebook-square","fa fa-camera-retro","fa fa-key","fa fa-gears","fa fa-comments","fa fa-thumbs-o-up","fa fa-thumbs-o-down","fa fa-star-half","fa fa-heart-o","fa fa-sign-out","fa fa-linkedin-square","fa fa-thumb-tack","fa fa-external-link","fa fa-sign-in","fa fa-trophy","fa fa-github-square","fa fa-upload","fa fa-lemon-o","fa fa-phone","fa fa-square-o","fa fa-bookmark-o","fa fa-phone-square","fa fa-twitter","fa fa-facebook-f","fa fa-github","fa fa-unlock","fa fa-credit-card","fa fa-feed","fa fa-hdd-o","fa fa-bullhorn","fa fa-bell","fa fa-certificate","fa fa-hand-o-right","fa fa-hand-o-left","fa fa-hand-o-up","fa fa-hand-o-down","fa fa-arrow-circle-left","fa fa-arrow-circle-right","fa fa-arrow-circle-up","fa fa-arrow-circle-down","fa fa-globe","fa fa-wrench","fa fa-tasks","fa fa-filter","fa fa-briefcase","fa fa-arrows-alt","fa fa-group","fa fa-chain","fa fa-cloud","fa fa-flask","fa fa-cut","fa fa-copy","fa fa-paperclip","fa fa-save","fa fa-square","fa fa-navicon","fa fa-list-ul","fa fa-list-ol","fa fa-strikethrough","fa fa-underline","fa fa-table","fa fa-magic","fa fa-truck","fa fa-pinterest","fa fa-pinterest-square","fa fa-google-plus-square","fa fa-google-plus","fa fa-money","fa fa-caret-down","fa fa-caret-up","fa fa-caret-left","fa fa-caret-right","fa fa-columns","fa fa-unsorted","fa fa-sort-down","fa fa-sort-up","fa fa-envelope","fa fa-linkedin","fa fa-rotate-left","fa fa-legal","fa fa-dashboard","fa fa-comment-o","fa fa-comments-o","fa fa-flash","fa fa-sitemap","fa fa-umbrella","fa fa-paste","fa fa-lightbulb-o","fa fa-exchange","fa fa-cloud-download","fa fa-cloud-upload","fa fa-user-md","fa fa-stethoscope","fa fa-suitcase","fa fa-bell-o","fa fa-coffee","fa fa-cutlery","fa fa-file-text-o","fa fa-building-o","fa fa-hospital-o","fa fa-ambulance","fa fa-medkit","fa fa-fighter-jet","fa fa-beer","fa fa-h-square","fa fa-plus-square","fa fa-angle-double-left","fa fa-angle-double-right","fa fa-angle-double-up","fa fa-angle-double-down","fa fa-angle-left","fa fa-angle-right","fa fa-angle-up","fa fa-angle-down","fa fa-desktop","fa fa-laptop","fa fa-tablet","fa fa-mobile-phone","fa fa-circle-o","fa fa-quote-left","fa fa-quote-right","fa fa-spinner","fa fa-circle","fa fa-mail-reply","fa fa-github-alt","fa fa-folder-o","fa fa-folder-open-o","fa fa-smile-o","fa fa-frown-o","fa fa-meh-o","fa fa-gamepad","fa fa-keyboard-o","fa fa-flag-o","fa fa-flag-checkered","fa fa-terminal","fa fa-code","fa fa-mail-reply-all","fa fa-star-half-empty","fa fa-location-arrow","fa fa-crop","fa fa-code-fork","fa fa-unlink","fa fa-question","fa fa-info","fa fa-exclamation","fa fa-superscript","fa fa-subscript","fa fa-eraser","fa fa-puzzle-piece","fa fa-microphone","fa fa-microphone-slash","fa fa-shield","fa fa-calendar-o","fa fa-fire-extinguisher","fa fa-rocket","fa fa-maxcdn","fa fa-chevron-circle-left","fa fa-chevron-circle-right","fa fa-chevron-circle-up","fa fa-chevron-circle-down","fa fa-html5","fa fa-css3","fa fa-anchor","fa fa-unlock-alt","fa fa-bullseye","fa fa-ellipsis-h","fa fa-ellipsis-v","fa fa-rss-square","fa fa-play-circle","fa fa-ticket","fa fa-minus-square","fa fa-minus-square-o","fa fa-level-up","fa fa-level-down","fa fa-check-square","fa fa-pencil-square","fa fa-external-link-square","fa fa-share-square","fa fa-compass","fa fa-toggle-down","fa fa-toggle-up","fa fa-toggle-right","fa fa-euro","fa fa-gbp","fa fa-dollar","fa fa-rupee","fa fa-cny","fa fa-ruble","fa fa-won","fa fa-bitcoin","fa fa-file","fa fa-file-text","fa fa-sort-alpha-asc","fa fa-sort-alpha-desc","fa fa-sort-amount-asc","fa fa-sort-amount-desc","fa fa-sort-numeric-asc","fa fa-sort-numeric-desc","fa fa-thumbs-up","fa fa-thumbs-down","fa fa-youtube-square","fa fa-youtube","fa fa-xing","fa fa-xing-square","fa fa-youtube-play","fa fa-dropbox","fa fa-stack-overflow","fa fa-instagram","fa fa-flickr","fa fa-adn","fa fa-bitbucket","fa fa-bitbucket-square","fa fa-tumblr","fa fa-tumblr-square","fa fa-long-arrow-down","fa fa-long-arrow-up","fa fa-long-arrow-left","fa fa-long-arrow-right","fa fa-apple","fa fa-windows","fa fa-android","fa fa-linux","fa fa-dribbble","fa fa-skype","fa fa-foursquare","fa fa-trello","fa fa-female","fa fa-male","fa fa-gittip","fa fa-sun-o","fa fa-moon-o","fa fa-archive","fa fa-bug","fa fa-vk","fa fa-weibo","fa fa-renren","fa fa-pagelines","fa fa-stack-exchange","fa fa-arrow-circle-o-right","fa fa-arrow-circle-o-left","fa fa-toggle-left","fa fa-dot-circle-o","fa fa-wheelchair","fa fa-vimeo-square","fa fa-turkish-lira","fa fa-plus-square-o","fa fa-space-shuttle","fa fa-slack","fa fa-envelope-square","fa fa-wordpress","fa fa-openid","fa fa-institution","fa fa-mortar-board","fa fa-yahoo","fa fa-google","fa fa-reddit","fa fa-reddit-square","fa fa-stumbleupon-circle","fa fa-stumbleupon","fa fa-delicious","fa fa-digg","fa fa-pied-piper-pp","fa fa-pied-piper-alt","fa fa-drupal","fa fa-joomla","fa fa-language","fa fa-fax","fa fa-building","fa fa-child","fa fa-paw","fa fa-spoon","fa fa-cube","fa fa-cubes","fa fa-behance","fa fa-behance-square","fa fa-steam","fa fa-steam-square","fa fa-recycle","fa fa-automobile","fa fa-cab","fa fa-tree","fa fa-spotify","fa fa-deviantart","fa fa-soundcloud","fa fa-database","fa fa-file-pdf-o","fa fa-file-word-o","fa fa-file-excel-o","fa fa-file-powerpoint-o","fa fa-file-photo-o","fa fa-file-zip-o","fa fa-file-sound-o","fa fa-file-movie-o","fa fa-file-code-o","fa fa-vine","fa fa-codepen","fa fa-jsfiddle","fa fa-life-bouy","fa fa-circle-o-notch","fa fa-ra","fa fa-ge","fa fa-git-square","fa fa-git","fa fa-y-combinator-square","fa fa-tencent-weibo","fa fa-qq","fa fa-wechat","fa fa-send","fa fa-send-o","fa fa-history","fa fa-circle-thin","fa fa-header","fa fa-paragraph","fa fa-sliders","fa fa-share-alt","fa fa-share-alt-square","fa fa-bomb","fa fa-soccer-ball-o","fa fa-tty","fa fa-binoculars","fa fa-plug","fa fa-slideshare","fa fa-twitch","fa fa-yelp","fa fa-newspaper-o","fa fa-wifi","fa fa-calculator","fa fa-paypal","fa fa-google-wallet","fa fa-cc-visa","fa fa-cc-mastercard","fa fa-cc-discover","fa fa-cc-amex","fa fa-cc-paypal","fa fa-cc-stripe","fa fa-bell-slash","fa fa-bell-slash-o","fa fa-trash","fa fa-copyright","fa fa-at","fa fa-eyedropper","fa fa-paint-brush","fa fa-birthday-cake","fa fa-area-chart","fa fa-pie-chart","fa fa-line-chart","fa fa-lastfm","fa fa-lastfm-square","fa fa-toggle-off","fa fa-toggle-on","fa fa-bicycle","fa fa-bus","fa fa-ioxhost","fa fa-angellist","fa fa-cc","fa fa-shekel","fa fa-meanpath","fa fa-buysellads","fa fa-connectdevelop","fa fa-dashcube","fa fa-forumbee","fa fa-leanpub","fa fa-sellsy","fa fa-shirtsinbulk","fa fa-simplybuilt","fa fa-skyatlas","fa fa-cart-plus","fa fa-cart-arrow-down","fa fa-diamond","fa fa-ship","fa fa-user-secret","fa fa-motorcycle","fa fa-street-view","fa fa-heartbeat","fa fa-venus","fa fa-mars","fa fa-mercury","fa fa-intersex","fa fa-transgender-alt","fa fa-venus-double","fa fa-mars-double","fa fa-venus-mars","fa fa-mars-stroke","fa fa-mars-stroke-v","fa fa-mars-stroke-h","fa fa-neuter","fa fa-genderless","fa fa-facebook-official","fa fa-pinterest-p","fa fa-whatsapp","fa fa-server","fa fa-user-plus","fa fa-user-times","fa fa-hotel","fa fa-viacoin","fa fa-train","fa fa-subway","fa fa-medium","fa fa-yc","fa fa-optin-monster","fa fa-opencart","fa fa-expeditedssl","fa fa-battery-4","fa fa-battery-3","fa fa-battery-2","fa fa-battery-1","fa fa-battery-0","fa fa-mouse-pointer","fa fa-i-cursor","fa fa-object-group","fa fa-object-ungroup","fa fa-sticky-note","fa fa-sticky-note-o","fa fa-cc-jcb","fa fa-cc-diners-club","fa fa-clone","fa fa-balance-scale","fa fa-hourglass-o","fa fa-hourglass-1","fa fa-hourglass-2","fa fa-hourglass-3","fa fa-hourglass","fa fa-hand-grab-o","fa fa-hand-stop-o","fa fa-hand-scissors-o","fa fa-hand-lizard-o","fa fa-hand-spock-o","fa fa-hand-pointer-o","fa fa-hand-peace-o","fa fa-trademark","fa fa-registered","fa fa-creative-commons","fa fa-gg","fa fa-gg-circle","fa fa-tripadvisor","fa fa-odnoklassniki","fa fa-odnoklassniki-square","fa fa-get-pocket","fa fa-wikipedia-w","fa fa-safari","fa fa-chrome","fa fa-firefox","fa fa-opera","fa fa-internet-explorer","fa fa-tv","fa fa-contao","fa fa-500px","fa fa-amazon","fa fa-calendar-plus-o","fa fa-calendar-minus-o","fa fa-calendar-times-o","fa fa-calendar-check-o","fa fa-industry","fa fa-map-pin","fa fa-map-signs","fa fa-map-o","fa fa-map","fa fa-commenting","fa fa-commenting-o","fa fa-houzz","fa fa-vimeo","fa fa-black-tie","fa fa-fonticons","fa fa-reddit-alien","fa fa-edge","fa fa-credit-card-alt","fa fa-codiepie","fa fa-modx","fa fa-fort-awesome","fa fa-usb","fa fa-product-hunt","fa fa-mixcloud","fa fa-scribd","fa fa-pause-circle","fa fa-pause-circle-o","fa fa-stop-circle","fa fa-stop-circle-o","fa fa-shopping-bag","fa fa-shopping-basket","fa fa-hashtag","fa fa-bluetooth","fa fa-bluetooth-b","fa fa-percent","fa fa-gitlab","fa fa-wpbeginner","fa fa-wpforms","fa fa-envira","fa fa-universal-access","fa fa-wheelchair-alt","fa fa-question-circle-o","fa fa-blind","fa fa-audio-description","fa fa-volume-control-phone","fa fa-braille","fa fa-assistive-listening-systems","fa fa-asl-interpreting","fa fa-deafness","fa fa-glide","fa fa-glide-g","fa fa-signing","fa fa-low-vision","fa fa-viadeo","fa fa-viadeo-square","fa fa-snapchat","fa fa-snapchat-ghost","fa fa-snapchat-square","fa fa-pied-piper","fa fa-first-order","fa fa-yoast","fa fa-themeisle","fa fa-google-plus-circle","fa fa-fa","fa fa-handshake-o","fa fa-envelope-open","fa fa-envelope-open-o","fa fa-linode","fa fa-address-book","fa fa-address-book-o","fa fa-vcard","fa fa-vcard-o","fa fa-user-circle","fa fa-user-circle-o","fa fa-user-o","fa fa-id-badge","fa fa-drivers-license","fa fa-drivers-license-o","fa fa-quora","fa fa-free-code-camp","fa fa-telegram","fa fa-thermometer-4","fa fa-thermometer-3","fa fa-thermometer-2","fa fa-thermometer-1","fa fa-thermometer-0","fa fa-shower","fa fa-bathtub","fa fa-podcast","fa fa-window-maximize","fa fa-window-minimize","fa fa-window-restore","fa fa-times-rectangle","fa fa-times-rectangle-o","fa fa-bandcamp","fa fa-grav","fa fa-etsy","fa fa-imdb","fa fa-ravelry","fa fa-eercast","fa fa-microchip","fa fa-snowflake-o","fa fa-superpowers","fa fa-wpexplorer","fa fa-meetup"],"Dripicons ( 16px grid )":["dripicons dripicons-alarm","dripicons dripicons-align-center","dripicons dripicons-align-justify","dripicons dripicons-align-left","dripicons dripicons-align-right","dripicons dripicons-anchor","dripicons dripicons-archive","dripicons dripicons-arrow-down","dripicons dripicons-arrow-left","dripicons dripicons-arrow-right","dripicons dripicons-arrow-thin-down","dripicons dripicons-arrow-thin-left","dripicons dripicons-arrow-thin-right","dripicons dripicons-arrow-thin-up","dripicons dripicons-arrow-up","dripicons dripicons-article","dripicons dripicons-backspace","dripicons dripicons-basket","dripicons dripicons-basketball","dripicons dripicons-battery-empty","dripicons dripicons-battery-full","dripicons dripicons-battery-low","dripicons dripicons-battery-medium","dripicons dripicons-bell","dripicons dripicons-blog","dripicons dripicons-bluetooth","dripicons dripicons-bold","dripicons dripicons-bookmark","dripicons dripicons-bookmarks","dripicons dripicons-box","dripicons dripicons-briefcase","dripicons dripicons-brightness-low","dripicons dripicons-brightness-max","dripicons dripicons-brightness-medium","dripicons dripicons-broadcast","dripicons dripicons-browser","dripicons dripicons-browser-upload","dripicons dripicons-brush","dripicons dripicons-calendar","dripicons dripicons-camcorder","dripicons dripicons-camera","dripicons dripicons-card","dripicons dripicons-cart","dripicons dripicons-checklist","dripicons dripicons-checkmark","dripicons dripicons-chevron-down","dripicons dripicons-chevron-left","dripicons dripicons-chevron-right","dripicons dripicons-chevron-up","dripicons dripicons-clipboard","dripicons dripicons-clock","dripicons dripicons-clockwise","dripicons dripicons-cloud","dripicons dripicons-cloud-download","dripicons dripicons-cloud-upload","dripicons dripicons-code","dripicons dripicons-contract","dripicons dripicons-contract-2","dripicons dripicons-conversation","dripicons dripicons-copy","dripicons dripicons-crop","dripicons dripicons-cross","dripicons dripicons-crosshair","dripicons dripicons-cutlery","dripicons dripicons-device-desktop","dripicons dripicons-device-mobile","dripicons dripicons-device-tablet","dripicons dripicons-direction","dripicons dripicons-disc","dripicons dripicons-document","dripicons dripicons-document-delete","dripicons dripicons-document-edit","dripicons dripicons-document-new","dripicons dripicons-document-remove","dripicons dripicons-dot","dripicons dripicons-dots-2","dripicons dripicons-dots-3","dripicons dripicons-download","dripicons dripicons-duplicate","dripicons dripicons-enter","dripicons dripicons-exit","dripicons dripicons-expand","dripicons dripicons-expand-2","dripicons dripicons-experiment","dripicons dripicons-export","dripicons dripicons-feed","dripicons dripicons-flag","dripicons dripicons-flashlight","dripicons dripicons-folder","dripicons dripicons-folder-open","dripicons dripicons-forward","dripicons dripicons-gaming","dripicons dripicons-gear","dripicons dripicons-graduation","dripicons dripicons-graph-bar","dripicons dripicons-graph-line","dripicons dripicons-graph-pie","dripicons dripicons-headset","dripicons dripicons-heart","dripicons dripicons-help","dripicons dripicons-home","dripicons dripicons-hourglass","dripicons dripicons-inbox","dripicons dripicons-information","dripicons dripicons-italic","dripicons dripicons-jewel","dripicons dripicons-lifting","dripicons dripicons-lightbulb","dripicons dripicons-link","dripicons dripicons-link-broken","dripicons dripicons-list","dripicons dripicons-loading","dripicons dripicons-location","dripicons dripicons-lock","dripicons dripicons-lock-open","dripicons dripicons-mail","dripicons dripicons-map","dripicons dripicons-media-loop","dripicons dripicons-media-next","dripicons dripicons-media-pause","dripicons dripicons-media-play","dripicons dripicons-media-previous","dripicons dripicons-media-record","dripicons dripicons-media-shuffle","dripicons dripicons-media-stop","dripicons dripicons-medical","dripicons dripicons-menu","dripicons dripicons-message","dripicons dripicons-meter","dripicons dripicons-microphone","dripicons dripicons-minus","dripicons dripicons-monitor","dripicons dripicons-move","dripicons dripicons-music","dripicons dripicons-network-1","dripicons dripicons-network-2","dripicons dripicons-network-3","dripicons dripicons-network-4","dripicons dripicons-network-5","dripicons dripicons-pamphlet","dripicons dripicons-paperclip","dripicons dripicons-pencil","dripicons dripicons-phone","dripicons dripicons-photo","dripicons dripicons-photo-group","dripicons dripicons-pill","dripicons dripicons-pin","dripicons dripicons-plus","dripicons dripicons-power","dripicons dripicons-preview","dripicons dripicons-print","dripicons dripicons-pulse","dripicons dripicons-question","dripicons dripicons-reply","dripicons dripicons-reply-all","dripicons dripicons-return","dripicons dripicons-retweet","dripicons dripicons-rocket","dripicons dripicons-scale","dripicons dripicons-search","dripicons dripicons-shopping-bag","dripicons dripicons-skip","dripicons dripicons-stack","dripicons dripicons-star","dripicons dripicons-stopwatch","dripicons dripicons-store","dripicons dripicons-suitcase","dripicons dripicons-swap","dripicons dripicons-tag","dripicons dripicons-tag-delete","dripicons dripicons-tags","dripicons dripicons-thumbs-down","dripicons dripicons-thumbs-up","dripicons dripicons-ticket","dripicons dripicons-time-reverse","dripicons dripicons-to-do","dripicons dripicons-toggles","dripicons dripicons-trash","dripicons dripicons-trophy","dripicons dripicons-upload","dripicons dripicons-user","dripicons dripicons-user-group","dripicons dripicons-user-id","dripicons dripicons-vibrate","dripicons dripicons-view-apps","dripicons dripicons-view-list","dripicons dripicons-view-list-large","dripicons dripicons-view-thumb","dripicons dripicons-volume-full","dripicons dripicons-volume-low","dripicons dripicons-volume-medium","dripicons dripicons-volume-off","dripicons dripicons-wallet","dripicons dripicons-warning","dripicons dripicons-web","dripicons dripicons-weight","dripicons dripicons-wifi","dripicons dripicons-wrong","dripicons dripicons-zoom-in","dripicons dripicons-zoom-out"],"Linea ( 16px grid )":["linea linea-arrows_anticlockwise","linea linea-arrows_anticlockwise_dashed","linea linea-arrows_button_down","linea linea-arrows_button_off","linea linea-arrows_button_on","linea linea-arrows_button_up","linea linea-arrows_check","linea linea-arrows_circle_check","linea linea-arrows_circle_down","linea linea-arrows_circle_downleft","linea linea-arrows_circle_downright","linea linea-arrows_circle_left","linea linea-arrows_circle_minus","linea linea-arrows_circle_plus","linea linea-arrows_circle_remove","linea linea-arrows_circle_right","linea linea-arrows_circle_up","linea linea-arrows_circle_upleft","linea linea-arrows_circle_upright","linea linea-arrows_clockwise","linea linea-arrows_clockwise_dashed","linea linea-arrows_compress","linea linea-arrows_deny","linea linea-arrows_diagonal","linea linea-arrows_diagonal2","linea linea-arrows_down","linea linea-arrows_down_double-34","linea linea-arrows_downleft","linea linea-arrows_downright","linea linea-arrows_drag_down","linea linea-arrows_drag_down_dashed","linea linea-arrows_drag_horiz","linea linea-arrows_drag_left","linea linea-arrows_drag_left_dashed","linea linea-arrows_drag_right","linea linea-arrows_drag_right_dashed","linea linea-arrows_drag_up","linea linea-arrows_drag_up_dashed","linea linea-arrows_drag_vert","linea linea-arrows_exclamation","linea linea-arrows_expand","linea linea-arrows_expand_diagonal1","linea linea-arrows_expand_horizontal1","linea linea-arrows_expand_vertical1","linea linea-arrows_fit_horizontal","linea linea-arrows_fit_vertical","linea linea-arrows_glide","linea linea-arrows_glide_horizontal","linea linea-arrows_glide_vertical","linea linea-arrows_hamburger-2","linea linea-arrows_hamburger1","linea linea-arrows_horizontal","linea linea-arrows_info","linea linea-arrows_keyboard_alt","linea linea-arrows_keyboard_cmd-29","linea linea-arrows_keyboard_delete","linea linea-arrows_keyboard_down-28","linea linea-arrows_keyboard_left","linea linea-arrows_keyboard_return","linea linea-arrows_keyboard_right","linea linea-arrows_keyboard_shift","linea linea-arrows_keyboard_tab","linea linea-arrows_keyboard_up","linea linea-arrows_left","linea linea-arrows_left_double-32","linea linea-arrows_minus","linea linea-arrows_move","linea linea-arrows_move_bottom","linea linea-arrows_move_left","linea linea-arrows_move_right","linea linea-arrows_move_top","linea linea-arrows_move2","linea linea-arrows_plus","linea linea-arrows_question","linea linea-arrows_remove","linea linea-arrows_right","linea linea-arrows_right_double-31","linea linea-arrows_rotate","linea linea-arrows_rotate_anti","linea linea-arrows_rotate_anti_dashed","linea linea-arrows_rotate_dashed","linea linea-arrows_shrink","linea linea-arrows_shrink_diagonal1","linea linea-arrows_shrink_diagonal2","linea linea-arrows_shrink_horizonal2","linea linea-arrows_shrink_horizontal1","linea linea-arrows_shrink_vertical1","linea linea-arrows_shrink_vertical2","linea linea-arrows_sign_down","linea linea-arrows_sign_left","linea linea-arrows_sign_right","linea linea-arrows_sign_up","linea linea-arrows_slide_down1","linea linea-arrows_slide_down2","linea linea-arrows_slide_left1","linea linea-arrows_slide_left2","linea linea-arrows_slide_right1","linea linea-arrows_slide_right2","linea linea-arrows_slide_up1","linea linea-arrows_slide_up2","linea linea-arrows_slim_down","linea linea-arrows_slim_down_dashed","linea linea-arrows_slim_left","linea linea-arrows_slim_left_dashed","linea linea-arrows_slim_right","linea linea-arrows_slim_right_dashed","linea linea-arrows_slim_up","linea linea-arrows_slim_up_dashed","linea linea-arrows_square_check","linea linea-arrows_square_down","linea linea-arrows_square_downleft","linea linea-arrows_square_downright","linea linea-arrows_square_left","linea linea-arrows_square_minus","linea linea-arrows_square_plus","linea linea-arrows_square_remove","linea linea-arrows_square_right","linea linea-arrows_square_up","linea linea-arrows_square_upleft","linea linea-arrows_square_upright","linea linea-arrows_squares","linea linea-arrows_stretch_diagonal1","linea linea-arrows_stretch_diagonal2","linea linea-arrows_stretch_diagonal3","linea linea-arrows_stretch_diagonal4","linea linea-arrows_stretch_horizontal1","linea linea-arrows_stretch_horizontal2","linea linea-arrows_stretch_vertical1","linea linea-arrows_stretch_vertical2","linea linea-arrows_switch_horizontal","linea linea-arrows_switch_vertical","linea linea-arrows_up","linea linea-arrows_up_double-33","linea linea-arrows_upleft","linea linea-arrows_upright","linea linea-arrows_vertical","linea linea-basic_accelerator","linea linea-basic_alarm","linea linea-basic_anchor","linea linea-basic_anticlockwise","linea linea-basic_archive","linea linea-basic_archive_full","linea linea-basic_ban","linea linea-basic_battery_charge","linea linea-basic_battery_empty","linea linea-basic_battery_full","linea linea-basic_battery_half","linea linea-basic_bolt","linea linea-basic_book","linea linea-basic_book_pen","linea linea-basic_book_pencil","linea linea-basic_bookmark","linea linea-basic_calculator","linea linea-basic_calendar","linea linea-basic_cards_diamonds","linea linea-basic_cards_hearts","linea linea-basic_case","linea linea-basic_chronometer","linea linea-basic_clessidre","linea linea-basic_clock","linea linea-basic_clockwise","linea linea-basic_cloud","linea linea-basic_clubs","linea linea-basic_compass","linea linea-basic_cup","linea linea-basic_diamonds","linea linea-basic_display","linea linea-basic_download","linea linea-basic_exclamation","linea linea-basic_eye","linea linea-basic_eye_closed","linea linea-basic_female","linea linea-basic_flag1","linea linea-basic_flag2","linea linea-basic_floppydisk","linea linea-basic_folder","linea linea-basic_folder_multiple","linea linea-basic_gear","linea linea-basic_geolocalize-01","linea linea-basic_geolocalize-05","linea linea-basic_globe","linea linea-basic_gunsight","linea linea-basic_hammer","linea linea-basic_headset","linea linea-basic_heart","linea linea-basic_heart_broken","linea linea-basic_helm","linea linea-basic_home","linea linea-basic_info","linea linea-basic_ipod","linea linea-basic_joypad","linea linea-basic_key","linea linea-basic_keyboard","linea linea-basic_laptop","linea linea-basic_life_buoy","linea linea-basic_lightbulb","linea linea-basic_link","linea linea-basic_lock","linea linea-basic_lock_open","linea linea-basic_magic_mouse","linea linea-basic_magnifier","linea linea-basic_magnifier_minus","linea linea-basic_magnifier_plus","linea linea-basic_mail","linea linea-basic_mail_multiple","linea linea-basic_mail_open","linea linea-basic_mail_open_text","linea linea-basic_male","linea linea-basic_map","linea linea-basic_message","linea linea-basic_message_multiple","linea linea-basic_message_txt","linea linea-basic_mixer2","linea linea-basic_mouse","linea linea-basic_notebook","linea linea-basic_notebook_pen","linea linea-basic_notebook_pencil","linea linea-basic_paperplane","linea linea-basic_pencil_ruler","linea linea-basic_pencil_ruler_pen","linea linea-basic_photo","linea linea-basic_picture","linea linea-basic_picture_multiple","linea linea-basic_pin1","linea linea-basic_pin2","linea linea-basic_postcard","linea linea-basic_postcard_multiple","linea linea-basic_printer","linea linea-basic_question","linea linea-basic_rss","linea linea-basic_server","linea linea-basic_server_cloud","linea linea-basic_server_download","linea linea-basic_server_upload","linea linea-basic_server2","linea linea-basic_settings","linea linea-basic_share","linea linea-basic_sheet","linea linea-basic_sheet_multiple","linea linea-basic_sheet_pen","linea linea-basic_sheet_pencil","linea linea-basic_sheet_txt","linea linea-basic_signs","linea linea-basic_smartphone","linea linea-basic_spades","linea linea-basic_spread","linea linea-basic_spread_bookmark","linea linea-basic_spread_text","linea linea-basic_spread_text_bookmark","linea linea-basic_star","linea linea-basic_tablet","linea linea-basic_target","linea linea-basic_todo","linea linea-basic_todo_pen","linea linea-basic_todo_pencil","linea linea-basic_todo_txt","linea linea-basic_todolist_pen","linea linea-basic_todolist_pencil","linea linea-basic_trashcan","linea linea-basic_trashcan_full","linea linea-basic_trashcan_refresh","linea linea-basic_trashcan_remove","linea linea-basic_upload","linea linea-basic_usb","linea linea-basic_video","linea linea-basic_watch","linea linea-basic_webpage","linea linea-basic_webpage_img_txt","linea linea-basic_webpage_multiple","linea linea-basic_webpage_txt","linea linea-basic_world","linea linea-basic_elaboration_bookmark_checck","linea linea-basic_elaboration_bookmark_minus","linea linea-basic_elaboration_bookmark_plus","linea linea-basic_elaboration_bookmark_remove","linea linea-basic_elaboration_briefcase_check","linea linea-basic_elaboration_briefcase_download","linea linea-basic_elaboration_briefcase_flagged","linea linea-basic_elaboration_briefcase_minus","linea linea-basic_elaboration_briefcase_plus","linea linea-basic_elaboration_briefcase_refresh","linea linea-basic_elaboration_briefcase_remove","linea linea-basic_elaboration_briefcase_search","linea linea-basic_elaboration_briefcase_star","linea linea-basic_elaboration_briefcase_upload","linea linea-basic_elaboration_browser_check","linea linea-basic_elaboration_browser_download","linea linea-basic_elaboration_browser_minus","linea linea-basic_elaboration_browser_plus","linea linea-basic_elaboration_browser_refresh","linea linea-basic_elaboration_browser_remove","linea linea-basic_elaboration_browser_search","linea linea-basic_elaboration_browser_star","linea linea-basic_elaboration_browser_upload","linea linea-basic_elaboration_calendar_check","linea linea-basic_elaboration_calendar_cloud","linea linea-basic_elaboration_calendar_download","linea linea-basic_elaboration_calendar_empty","linea linea-basic_elaboration_calendar_flagged","linea linea-basic_elaboration_calendar_heart","linea linea-basic_elaboration_calendar_minus","linea linea-basic_elaboration_calendar_next","linea linea-basic_elaboration_calendar_noaccess","linea linea-basic_elaboration_calendar_pencil","linea linea-basic_elaboration_calendar_plus","linea linea-basic_elaboration_calendar_previous","linea linea-basic_elaboration_calendar_refresh","linea linea-basic_elaboration_calendar_remove","linea linea-basic_elaboration_calendar_search","linea linea-basic_elaboration_calendar_star","linea linea-basic_elaboration_calendar_upload","linea linea-basic_elaboration_cloud_check","linea linea-basic_elaboration_cloud_download","linea linea-basic_elaboration_cloud_minus","linea linea-basic_elaboration_cloud_noaccess","linea linea-basic_elaboration_cloud_plus","linea linea-basic_elaboration_cloud_refresh","linea linea-basic_elaboration_cloud_remove","linea linea-basic_elaboration_cloud_search","linea linea-basic_elaboration_cloud_upload","linea linea-basic_elaboration_document_check","linea linea-basic_elaboration_document_cloud","linea linea-basic_elaboration_document_download","linea linea-basic_elaboration_document_flagged","linea linea-basic_elaboration_document_graph","linea linea-basic_elaboration_document_heart","linea linea-basic_elaboration_document_minus","linea linea-basic_elaboration_document_next","linea linea-basic_elaboration_document_noaccess","linea linea-basic_elaboration_document_note","linea linea-basic_elaboration_document_pencil","linea linea-basic_elaboration_document_picture","linea linea-basic_elaboration_document_plus","linea linea-basic_elaboration_document_previous","linea linea-basic_elaboration_document_refresh","linea linea-basic_elaboration_document_remove","linea linea-basic_elaboration_document_search","linea linea-basic_elaboration_document_star","linea linea-basic_elaboration_document_upload","linea linea-basic_elaboration_folder_check","linea linea-basic_elaboration_folder_cloud","linea linea-basic_elaboration_folder_document","linea linea-basic_elaboration_folder_download","linea linea-basic_elaboration_folder_flagged","linea linea-basic_elaboration_folder_graph","linea linea-basic_elaboration_folder_heart","linea linea-basic_elaboration_folder_minus","linea linea-basic_elaboration_folder_next","linea linea-basic_elaboration_folder_noaccess","linea linea-basic_elaboration_folder_note","linea linea-basic_elaboration_folder_pencil","linea linea-basic_elaboration_folder_picture","linea linea-basic_elaboration_folder_plus","linea linea-basic_elaboration_folder_previous","linea linea-basic_elaboration_folder_refresh","linea linea-basic_elaboration_folder_remove","linea linea-basic_elaboration_folder_search","linea linea-basic_elaboration_folder_star","linea linea-basic_elaboration_folder_upload","linea linea-basic_elaboration_mail_check","linea linea-basic_elaboration_mail_cloud","linea linea-basic_elaboration_mail_document","linea linea-basic_elaboration_mail_download","linea linea-basic_elaboration_mail_flagged","linea linea-basic_elaboration_mail_heart","linea linea-basic_elaboration_mail_next","linea linea-basic_elaboration_mail_noaccess","linea linea-basic_elaboration_mail_note","linea linea-basic_elaboration_mail_pencil","linea linea-basic_elaboration_mail_picture","linea linea-basic_elaboration_mail_previous","linea linea-basic_elaboration_mail_refresh","linea linea-basic_elaboration_mail_remove","linea linea-basic_elaboration_mail_search","linea linea-basic_elaboration_mail_star","linea linea-basic_elaboration_mail_upload","linea linea-basic_elaboration_message_check","linea linea-basic_elaboration_message_dots","linea linea-basic_elaboration_message_happy","linea linea-basic_elaboration_message_heart","linea linea-basic_elaboration_message_minus","linea linea-basic_elaboration_message_note","linea linea-basic_elaboration_message_plus","linea linea-basic_elaboration_message_refresh","linea linea-basic_elaboration_message_remove","linea linea-basic_elaboration_message_sad","linea linea-basic_elaboration_smartphone_cloud","linea linea-basic_elaboration_smartphone_heart","linea linea-basic_elaboration_smartphone_noaccess","linea linea-basic_elaboration_smartphone_note","linea linea-basic_elaboration_smartphone_pencil","linea linea-basic_elaboration_smartphone_picture","linea linea-basic_elaboration_smartphone_refresh","linea linea-basic_elaboration_smartphone_search","linea linea-basic_elaboration_tablet_cloud","linea linea-basic_elaboration_tablet_heart","linea linea-basic_elaboration_tablet_noaccess","linea linea-basic_elaboration_tablet_note","linea linea-basic_elaboration_tablet_pencil","linea linea-basic_elaboration_tablet_picture","linea linea-basic_elaboration_tablet_refresh","linea linea-basic_elaboration_tablet_search","linea linea-basic_elaboration_todolist_2","linea linea-basic_elaboration_todolist_check","linea linea-basic_elaboration_todolist_cloud","linea linea-basic_elaboration_todolist_download","linea linea-basic_elaboration_todolist_flagged","linea linea-basic_elaboration_todolist_minus","linea linea-basic_elaboration_todolist_noaccess","linea linea-basic_elaboration_todolist_pencil","linea linea-basic_elaboration_todolist_plus","linea linea-basic_elaboration_todolist_refresh","linea linea-basic_elaboration_todolist_remove","linea linea-basic_elaboration_todolist_search","linea linea-basic_elaboration_todolist_star","linea linea-basic_elaboration_todolist_upload","linea linea-ecommerce_bag","linea linea-ecommerce_bag_check","linea linea-ecommerce_bag_cloud","linea linea-ecommerce_bag_download","linea linea-ecommerce_bag_minus","linea linea-ecommerce_bag_plus","linea linea-ecommerce_bag_refresh","linea linea-ecommerce_bag_remove","linea linea-ecommerce_bag_search","linea linea-ecommerce_bag_upload","linea linea-ecommerce_banknote","linea linea-ecommerce_banknotes","linea linea-ecommerce_basket","linea linea-ecommerce_basket_check","linea linea-ecommerce_basket_cloud","linea linea-ecommerce_basket_download","linea linea-ecommerce_basket_minus","linea linea-ecommerce_basket_plus","linea linea-ecommerce_basket_refresh","linea linea-ecommerce_basket_remove","linea linea-ecommerce_basket_search","linea linea-ecommerce_basket_upload","linea linea-ecommerce_bath","linea linea-ecommerce_cart","linea linea-ecommerce_cart_check","linea linea-ecommerce_cart_cloud","linea linea-ecommerce_cart_content","linea linea-ecommerce_cart_download","linea linea-ecommerce_cart_minus","linea linea-ecommerce_cart_plus","linea linea-ecommerce_cart_refresh","linea linea-ecommerce_cart_remove","linea linea-ecommerce_cart_search","linea linea-ecommerce_cart_upload","linea linea-ecommerce_cent","linea linea-ecommerce_colon","linea linea-ecommerce_creditcard","linea linea-ecommerce_diamond","linea linea-ecommerce_dollar","linea linea-ecommerce_euro","linea linea-ecommerce_franc","linea linea-ecommerce_gift","linea linea-ecommerce_graph_decrease","linea linea-ecommerce_graph_increase","linea linea-ecommerce_graph1","linea linea-ecommerce_graph2","linea linea-ecommerce_graph3","linea linea-ecommerce_guarani","linea linea-ecommerce_kips","linea linea-ecommerce_lira","linea linea-ecommerce_megaphone","linea linea-ecommerce_money","linea linea-ecommerce_naira","linea linea-ecommerce_pesos","linea linea-ecommerce_pound","linea linea-ecommerce_receipt","linea linea-ecommerce_receipt_bath","linea linea-ecommerce_receipt_cent","linea linea-ecommerce_receipt_dollar","linea linea-ecommerce_receipt_euro","linea linea-ecommerce_receipt_franc","linea linea-ecommerce_receipt_guarani","linea linea-ecommerce_receipt_kips","linea linea-ecommerce_receipt_lira","linea linea-ecommerce_receipt_naira","linea linea-ecommerce_receipt_pesos","linea linea-ecommerce_receipt_pound","linea linea-ecommerce_receipt_rublo","linea linea-ecommerce_receipt_rupee","linea linea-ecommerce_receipt_tugrik","linea linea-ecommerce_receipt_won","linea linea-ecommerce_receipt_yen","linea linea-ecommerce_receipt_yen2","linea linea-ecommerce_recept_colon","linea linea-ecommerce_rublo","linea linea-ecommerce_rupee","linea linea-ecommerce_safe","linea linea-ecommerce_sale","linea linea-ecommerce_sales","linea linea-ecommerce_ticket","linea linea-ecommerce_tugriks","linea linea-ecommerce_wallet","linea linea-ecommerce_won","linea linea-ecommerce_yen","linea linea-ecommerce_yen2","linea linea-music_beginning_button","linea linea-music_bell","linea linea-music_cd","linea linea-music_diapason","linea linea-music_eject_button","linea linea-music_end_button","linea linea-music_fastforward_button","linea linea-music_headphones","linea linea-music_ipod","linea linea-music_loudspeaker","linea linea-music_microphone","linea linea-music_microphone_old","linea linea-music_mixer","linea linea-music_mute","linea linea-music_note_multiple","linea linea-music_note_single","linea linea-music_pause_button","linea linea-music_play_button","linea linea-music_playlist","linea linea-music_radio_ghettoblaster","linea linea-music_radio_portable","linea linea-music_record","linea linea-music_recordplayer","linea linea-music_repeat_button","linea linea-music_rewind_button","linea linea-music_shuffle_button","linea linea-music_stop_button","linea linea-music_tape","linea linea-music_volume_down","linea linea-music_volume_up","linea linea-weather_aquarius","linea linea-weather_aries","linea linea-weather_cancer","linea linea-weather_capricorn","linea linea-weather_cloud","linea linea-weather_cloud_drop","linea linea-weather_cloud_lightning","linea linea-weather_cloud_snowflake","linea linea-weather_downpour_fullmoon","linea linea-weather_downpour_halfmoon","linea linea-weather_downpour_sun","linea linea-weather_drop","linea linea-weather_first_quarter","linea linea-weather_fog","linea linea-weather_fog_fullmoon","linea linea-weather_fog_halfmoon","linea linea-weather_fog_sun","linea linea-weather_fullmoon","linea linea-weather_gemini","linea linea-weather_hail","linea linea-weather_hail_fullmoon","linea linea-weather_hail_halfmoon","linea linea-weather_hail_sun","linea linea-weather_last_quarter","linea linea-weather_leo","linea linea-weather_libra","linea linea-weather_lightning","linea linea-weather_mistyrain","linea linea-weather_mistyrain_fullmoon","linea linea-weather_mistyrain_halfmoon","linea linea-weather_mistyrain_sun","linea linea-weather_moon","linea linea-weather_moondown_full","linea linea-weather_moondown_half","linea linea-weather_moonset_full","linea linea-weather_moonset_half","linea linea-weather_move2","linea linea-weather_newmoon","linea linea-weather_pisces","linea linea-weather_rain","linea linea-weather_rain_fullmoon","linea linea-weather_rain_halfmoon","linea linea-weather_rain_sun","linea linea-weather_sagittarius","linea linea-weather_scorpio","linea linea-weather_snow","linea linea-weather_snow_fullmoon","linea linea-weather_snow_halfmoon","linea linea-weather_snow_sun","linea linea-weather_snowflake","linea linea-weather_star","linea linea-weather_storm_fullmoon","linea linea-weather_storm_halfmoon","linea linea-weather_storm_sun","linea linea-weather_storm-11","linea linea-weather_storm-32","linea linea-weather_sun","linea linea-weather_sundown","linea linea-weather_sunset","linea linea-weather_taurus","linea linea-weather_tempest","linea linea-weather_tempest_fullmoon","linea linea-weather_tempest_halfmoon","linea linea-weather_tempest_sun","linea linea-weather_variable_fullmoon","linea linea-weather_variable_halfmoon","linea linea-weather_variable_sun","linea linea-weather_virgo","linea linea-weather_waning_cresent","linea linea-weather_waning_gibbous","linea linea-weather_waxing_cresent","linea linea-weather_waxing_gibbous","linea linea-weather_wind","linea linea-weather_wind_E","linea linea-weather_wind_fullmoon","linea linea-weather_wind_halfmoon","linea linea-weather_wind_N","linea linea-weather_wind_NE","linea linea-weather_wind_NW","linea linea-weather_wind_S","linea linea-weather_wind_SE","linea linea-weather_wind_sun","linea linea-weather_wind_SW","linea linea-weather_wind_W","linea linea-weather_windgust","linea linea-software_add_vectorpoint","linea linea-software_box_oval","linea linea-software_box_polygon","linea linea-software_box_rectangle","linea linea-software_box_roundedrectangle","linea linea-software_character","linea linea-software_crop","linea linea-software_eyedropper","linea linea-software_font_allcaps","linea linea-software_font_baseline_shift","linea linea-software_font_horizontal_scale","linea linea-software_font_kerning","linea linea-software_font_leading","linea linea-software_font_size","linea linea-software_font_smallcapital","linea linea-software_font_smallcaps","linea linea-software_font_strikethrough","linea linea-software_font_tracking","linea linea-software_font_underline","linea linea-software_font_vertical_scale","linea linea-software_horizontal_align_center","linea linea-software_horizontal_align_right","linea linea-software_horizontal_distribute_center","linea linea-software_horizontal_distribute_left","linea linea-software_horizontal_distribute_right","linea linea-software_indent_firstline","linea linea-software_indent_left","linea linea-software_indent_right","linea linea-software_lasso","linea linea-software_layers1","linea linea-software_layers2","linea linea-software_layout","linea linea-software_layout_2columns","linea linea-software_layout_3columns","linea linea-software_layout_4boxes","linea linea-software_layout_4columns","linea linea-software_layout_4lines","linea linea-software_layout_header","linea linea-software_layout_header_2columns","linea linea-software_layout_header_3columns","linea linea-software_layout_header_4boxes","linea linea-software_layout_header_4columns","linea linea-software_layout_header_complex","linea linea-software_layout_header_complex2","linea linea-software_layout_header_complex3","linea linea-software_layout_header_complex4","linea linea-software_layout_header_sideleft","linea linea-software_layout_header_sideright","linea linea-software_layout_sidebar_left","linea linea-software_layout_sidebar_right","linea linea-software_layout-8boxes","linea linea-software_magnete","linea linea-software_pages","linea linea-software_paintbrush","linea linea-software_paintbucket","linea linea-software_paintroller","linea linea-software_paragraph","linea linea-software_paragraph_align_left","linea linea-software_paragraph_align_right","linea linea-software_paragraph_center","linea linea-software_paragraph_justify_all","linea linea-software_paragraph_justify_center","linea linea-software_paragraph_justify_left","linea linea-software_paragraph_justify_right","linea linea-software_paragraph_space_after","linea linea-software_paragraph_space_before","linea linea-software_pathfinder_exclude","linea linea-software_pathfinder_intersect","linea linea-software_pathfinder_subtract","linea linea-software_pathfinder_unite","linea linea-software_pen","linea linea-software_pen_add","linea linea-software_pen_remove","linea linea-software_pencil","linea linea-software_polygonallasso","linea linea-software_reflect_horizontal","linea linea-software_reflect_vertical","linea linea-software_remove_vectorpoint","linea linea-software_scale_expand","linea linea-software_scale_reduce","linea linea-software_selection_oval","linea linea-software_selection_polygon","linea linea-software_selection_rectangle","linea linea-software_selection_roundedrectangle","linea linea-software_shape_oval","linea linea-software_shape_polygon","linea linea-software_shape_rectangle","linea linea-software_shape_roundedrectangle","linea linea-software_slice","linea linea-software_transform_bezier","linea linea-software_vector_box","linea linea-software_vector_composite","linea linea-software_vector_line","linea linea-software_vertical_align_bottom","linea linea-software_vertical_align_center","linea linea-software_vertical_align_top","linea linea-software_vertical_distribute_bottom","linea linea-software_vertical_distribute_center","linea linea-software_vertical_distribute_top","linea linea-software-horizontal_align_left"],"Linear ( 20px grid )":["lnr lnr-home","lnr lnr-apartment","lnr lnr-pencil","lnr lnr-magic-wand","lnr lnr-drop","lnr lnr-lighter","lnr lnr-poop","lnr lnr-sun","lnr lnr-moon","lnr lnr-cloud","lnr lnr-cloud-upload","lnr lnr-cloud-download","lnr lnr-cloud-sync","lnr lnr-cloud-check","lnr lnr-database","lnr lnr-lock","lnr lnr-cog","lnr lnr-trash","lnr lnr-dice","lnr lnr-heart","lnr lnr-star","lnr lnr-star-half","lnr lnr-star-empty","lnr lnr-flag","lnr lnr-envelope","lnr lnr-paperclip","lnr lnr-inbox","lnr lnr-eye","lnr lnr-printer","lnr lnr-file-empty","lnr lnr-file-add","lnr lnr-enter","lnr lnr-exit","lnr lnr-graduation-hat","lnr lnr-license","lnr lnr-music-note","lnr lnr-film-play","lnr lnr-camera-video","lnr lnr-camera","lnr lnr-picture","lnr lnr-book","lnr lnr-bookmark","lnr lnr-user","lnr lnr-users","lnr lnr-shirt","lnr lnr-store","lnr lnr-cart","lnr lnr-tag","lnr lnr-phone-handset","lnr lnr-phone","lnr lnr-pushpin","lnr lnr-map-marker","lnr lnr-map","lnr lnr-location","lnr lnr-calendar-full","lnr lnr-keyboard","lnr lnr-spell-check","lnr lnr-screen","lnr lnr-smartphone","lnr lnr-tablet","lnr lnr-laptop","lnr lnr-laptop-phone","lnr lnr-power-switch","lnr lnr-bubble","lnr lnr-heart-pulse","lnr lnr-construction","lnr lnr-pie-chart","lnr lnr-chart-bars","lnr lnr-gift","lnr lnr-diamond","lnr lnr-linearicons","lnr lnr-dinner","lnr lnr-coffee-cup","lnr lnr-leaf","lnr lnr-paw","lnr lnr-rocket","lnr lnr-briefcase","lnr lnr-bus","lnr lnr-car","lnr lnr-train","lnr lnr-bicycle","lnr lnr-wheelchair","lnr lnr-select","lnr lnr-earth","lnr lnr-smile","lnr lnr-sad","lnr lnr-neutral","lnr lnr-mustache","lnr lnr-alarm","lnr lnr-bullhorn","lnr lnr-volume-high","lnr lnr-volume-medium","lnr lnr-volume-low","lnr lnr-volume","lnr lnr-mic","lnr lnr-hourglass","lnr lnr-undo","lnr lnr-redo","lnr lnr-sync","lnr lnr-history","lnr lnr-clock","lnr lnr-download","lnr lnr-upload","lnr lnr-enter-down","lnr lnr-exit-up","lnr lnr-bug","lnr lnr-code","lnr lnr-link","lnr lnr-unlink","lnr lnr-thumbs-up","lnr lnr-thumbs-down","lnr lnr-magnifier","lnr lnr-cross","lnr lnr-menu","lnr lnr-list","lnr lnr-chevron-up","lnr lnr-chevron-down","lnr lnr-chevron-left","lnr lnr-chevron-right","lnr lnr-arrow-up","lnr lnr-arrow-down","lnr lnr-arrow-left","lnr lnr-arrow-right","lnr lnr-move","lnr lnr-warning","lnr lnr-question-circle","lnr lnr-menu-circle","lnr lnr-checkmark-circle","lnr lnr-cross-circle","lnr lnr-plus-circle","lnr lnr-circle-minus","lnr lnr-arrow-up-circle","lnr lnr-arrow-down-circle","lnr lnr-arrow-left-circle","lnr lnr-arrow-right-circle","lnr lnr-chevron-up-circle","lnr lnr-chevron-down-circle","lnr lnr-chevron-left-circle","lnr lnr-chevron-right-circle","lnr lnr-crop","lnr lnr-frame-expand","lnr lnr-frame-contract","lnr lnr-layers","lnr lnr-funnel","lnr lnr-text-format","lnr lnr-text-format-remove","lnr lnr-text-size","lnr lnr-bold","lnr lnr-italic","lnr lnr-underline","lnr lnr-strikethrough","lnr lnr-highlight","lnr lnr-text-align-left","lnr lnr-text-align-center","lnr lnr-text-align-right","lnr lnr-text-align-justify","lnr lnr-line-spacing","lnr lnr-indent-increase","lnr lnr-indent-decrease","lnr lnr-pilcrow","lnr lnr-direction-ltr","lnr lnr-direction-rtl","lnr lnr-page-break","lnr lnr-sort-alpha-asc","lnr lnr-sort-amount-asc","lnr lnr-hand","lnr lnr-pointer-up","lnr lnr-pointer-right","lnr lnr-pointer-down","lnr lnr-pointer-left"],"Linecons ( 16px grid )":["linecons linecons-heart2","linecons linecons-cloud3","linecons linecons-star5","linecons linecons-tv2","linecons linecons-sound2","linecons linecons-video","linecons linecons-trash3","linecons linecons-user2","linecons linecons-key3","linecons linecons-search2","linecons linecons-settings2","linecons linecons-camera","linecons linecons-tag3","linecons linecons-lock2","linecons linecons-bulb","linecons linecons-pen2","linecons linecons-diamond3","linecons linecons-display2","linecons linecons-location5","linecons linecons-eye5","linecons linecons-bubble3","linecons linecons-stack3","linecons linecons-cup2","linecons linecons-phone","linecons linecons-news","linecons linecons-mail2","linecons linecons-like","linecons linecons-photo","linecons linecons-note","linecons linecons-clock2","linecons linecons-paperplane","linecons linecons-params","linecons linecons-banknote","linecons linecons-data","linecons linecons-music3","linecons linecons-megaphone2","linecons linecons-study","linecons linecons-lab2","linecons linecons-food","linecons linecons-t-shirt","linecons linecons-fire2","linecons linecons-clip","linecons linecons-shop","linecons linecons-calendar2","linecons linecons-wallet2","linecons linecons-vynil","linecons linecons-truck2","linecons linecons-world"],"Streamline ( 24px grid )":["streamline streamline-type-1","streamline streamline-typist","streamline streamline-hand-point","streamline streamline-button","streamline streamline-call_to_action2","streamline streamline-bookmark-4","streamline streamline-artboard","streamline streamline-brush-1","streamline streamline-brush-2","streamline streamline-magnific_popup","streamline streamline-palette2","streamline streamline-pen-5","streamline streamline-stationery-1","streamline streamline-award-1","streamline streamline-award-2","streamline streamline-award-3","streamline streamline-award-4","streamline streamline-award-5","streamline streamline-award-6","streamline streamline-hand-like-2","streamline streamline-hand-unlike-2","streamline streamline-present","streamline streamline-icon_star2","streamline streamline-star-2","streamline streamline-star-3","streamline streamline-icon_boxes","streamline streamline-star-5","streamline streamline-star-6","streamline streamline-star-7","streamline streamline-star-8","streamline streamline-star-9","streamline streamline-trophy","streamline streamline-testimonials","streamline streamline-social_links","streamline streamline-hotspot-2","streamline streamline-sharing_links","streamline streamline-team_members","streamline streamline-image3","streamline streamline-image_hotspots","streamline streamline-media_gallery","streamline streamline-before_after","streamline streamline-movie-play-3","streamline streamline-media","streamline streamline-paragraph_text","streamline streamline-single_line_text","streamline streamline-exit_popup","streamline streamline-refresh2","streamline streamline-divider","streamline streamline-simple_slider","streamline streamline-scroll-horizontal-2","streamline streamline-sticky_menu","streamline streamline-sections_scroll_menu","streamline streamline-revolution_slider","streamline streamline-setting-gears-2","streamline streamline-switch-1","streamline streamline-switch-2","streamline streamline-calendar-1","streamline streamline-countdown","streamline streamline-counter","streamline streamline-map-location","streamline streamline-menu_anchor","streamline streamline-parse_page","streamline streamline-window-list-1","streamline streamline-single_choice","streamline streamline-progress_bars","streamline streamline-layer_slider","streamline streamline-accordions","streamline streamline-list-2","streamline streamline-contact_form","streamline streamline-registry-1","streamline streamline-registry-2","streamline streamline-items_gird","streamline streamline-hierarchy-1","streamline streamline-hierarchy-2","streamline streamline-dropdown_menu","streamline streamline-hierarchy-4","streamline streamline-network-2-1","streamline streamline-diamond5","streamline streamline-sofa-1","streamline streamline-sofa-2","streamline streamline-sofa-3","streamline streamline-html_code","streamline streamline-list-2-1","streamline streamline-special_heading","streamline streamline-text_block","streamline streamline-posts","streamline streamline-widget_area","streamline streamline-table","streamline streamline-tetris","streamline streamline-rocket4"],"Material ( 24px grid )":["mati mati-3d_rotation","mati mati-ac_unit","mati mati-alarm2","mati mati-access_alarms","mati mati-schedule","mati mati-accessibility2","mati mati-accessible","mati mati-account_balance","mati mati-account_balance_wallet","mati mati-account_box","mati mati-account_circle","mati mati-adb","mati mati-add","mati mati-add_a_photo","mati mati-alarm_add","mati mati-add_alert","mati mati-add_box","mati mati-add_circle","mati mati-control_point","mati mati-add_location","mati mati-add_shopping_cart","mati mati-queue","mati mati-add_to_queue","mati mati-adjust","mati mati-airline_seat_flat","mati mati-airline_seat_flat_angled","mati mati-airline_seat_individual_suite","mati mati-airline_seat_legroom_extra","mati mati-airline_seat_legroom_normal","mati mati-airline_seat_legroom_reduced","mati mati-airline_seat_recline_extra","mati mati-airline_seat_recline_normal","mati mati-flight","mati mati-airplanemode_inactive","mati mati-airplay","mati mati-airport_shuttle","mati mati-alarm_off","mati mati-alarm_on","mati mati-album","mati mati-all_inclusive","mati mati-all_out","mati mati-android2","mati mati-announcement","mati mati-apps","mati mati-archive2","mati mati-arrow_back2","mati mati-arrow_downward","mati mati-arrow_drop_down","mati mati-arrow_drop_down_circle","mati mati-arrow_drop_up","mati mati-arrow_forward","mati mati-arrow_upward","mati mati-art_track","mati mati-aspect_ratio","mati mati-poll","mati mati-assignment","mati mati-assignment_ind","mati mati-assignment_late","mati mati-assignment_return","mati mati-assignment_returned","mati mati-assignment_turned_in","mati mati-assistant","mati mati-flag","mati mati-attach_file","mati mati-attach_money","mati mati-attachment","mati mati-audiotrack","mati mati-autorenew","mati mati-av_timer","mati mati-backspace","mati mati-cloud_upload","mati mati-battery_alert","mati mati-battery_charging_full","mati mati-battery_std","mati mati-battery_unknown","mati mati-beach_access","mati mati-beenhere","mati mati-block","mati mati-bluetooth2","mati mati-bluetooth_searching","mati mati-bluetooth_connected","mati mati-bluetooth_disabled","mati mati-blur_circular","mati mati-blur_linear","mati mati-blur_off","mati mati-blur_on","mati mati-class","mati mati-turned_in","mati mati-turned_in_not","mati mati-border_all","mati mati-border_bottom","mati mati-border_clear","mati mati-border_color","mati mati-border_horizontal","mati mati-border_inner","mati mati-border_left","mati mati-border_outer","mati mati-border_right","mati mati-border_style","mati mati-border_top","mati mati-border_vertical","mati mati-branding_watermark","mati mati-brightness_1","mati mati-brightness_2","mati mati-brightness_3","mati mati-brightness_4","mati mati-brightness_low","mati mati-brightness_medium","mati mati-brightness_high","mati mati-brightness_auto","mati mati-broken_image","mati mati-brush2","mati mati-bubble_chart","mati mati-bug_report","mati mati-build","mati mati-burst_mode","mati mati-domain","mati mati-business_center","mati mati-cached","mati mati-cake3","mati mati-phone3","mati mati-call_end","mati mati-call_made","mati mati-merge_type","mati mati-call_missed","mati mati-call_missed_outgoing","mati mati-call_received","mati mati-call_split","mati mati-call_to_action","mati mati-camera4","mati mati-photo_camera","mati mati-camera_enhance","mati mati-camera_front","mati mati-camera_rear","mati mati-camera_roll","mati mati-cancel","mati mati-redeem","mati mati-card_membership","mati mati-card_travel","mati mati-casino","mati mati-cast","mati mati-cast_connected","mati mati-center_focus_strong","mati mati-center_focus_weak","mati mati-change_history","mati mati-chat2","mati mati-chat_bubble","mati mati-chat_bubble_outline","mati mati-check3","mati mati-check_box","mati mati-check_box_outline_blank","mati mati-check_circle","mati mati-child_care","mati mati-child_friendly","mati mati-chrome_reader_mode","mati mati-close","mati mati-clear_all","mati mati-closed_caption","mati mati-wb_cloudy","mati mati-cloud_circle","mati mati-cloud_done","mati mati-cloud_download","mati mati-cloud_off","mati mati-cloud_queue","mati mati-code2","mati mati-photo_library","mati mati-collections_bookmark","mati mati-palette","mati mati-colorize","mati mati-comment3","mati mati-compare","mati mati-compare_arrows","mati mati-laptop","mati mati-confirmation_number","mati mati-contact_mail","mati mati-contact_phone","mati mati-contacts","mati mati-content_copy","mati mati-content_cut","mati mati-content_paste","mati mati-control_point_duplicate","mati mati-copyright","mati mati-mode_edit","mati mati-create_new_folder","mati mati-payment","mati mati-crop3","mati mati-crop_16_9","mati mati-crop_3_2","mati mati-crop_landscape","mati mati-crop_7_5","mati mati-crop_din","mati mati-crop_free","mati mati-crop_original","mati mati-crop_portrait","mati mati-crop_rotate","mati mati-crop_square","mati mati-dashboard3","mati mati-data_usage","mati mati-date_range","mati mati-dehaze","mati mati-delete2","mati mati-delete_forever","mati mati-delete_sweep","mati mati-description","mati mati-desktop_mac","mati mati-desktop_windows","mati mati-details","mati mati-developer_board","mati mati-developer_mode","mati mati-device_hub","mati mati-phonelink","mati mati-devices_other","mati mati-dialer_sip","mati mati-dialpad","mati mati-directions","mati mati-directions_bike","mati mati-directions_boat","mati mati-directions_bus","mati mati-directions_car","mati mati-directions_railway","mati mati-directions_run","mati mati-directions_transit","mati mati-directions_walk","mati mati-disc_full","mati mati-dns","mati mati-not_interested","mati mati-do_not_disturb_alt","mati mati-do_not_disturb_off","mati mati-remove_circle","mati mati-dock","mati mati-done","mati mati-done_all","mati mati-donut_large","mati mati-donut_small","mati mati-drafts","mati mati-drag_handle","mati mati-time_to_leave","mati mati-dvr","mati mati-edit_location","mati mati-eject2","mati mati-markunread","mati mati-enhanced_encryption","mati mati-equalizer","mati mati-error","mati mati-error_outline","mati mati-euro_symbol","mati mati-ev_station","mati mati-insert_invitation","mati mati-event_available","mati mati-event_busy","mati mati-event_note","mati mati-event_seat","mati mati-exit_to_app","mati mati-explicit","mati mati-explore","mati mati-exposure","mati mati-exposure_neg_1","mati mati-exposure_neg_2","mati mati-exposure_plus_1","mati mati-exposure_plus_2","mati mati-exposure_zero","mati mati-extension","mati mati-face","mati mati-fast_forward","mati mati-fast_rewind","mati mati-favorite","mati mati-favorite_border","mati mati-featured_play_list","mati mati-featured_video","mati mati-sms_failed","mati mati-fiber_dvr","mati mati-fiber_manual_record","mati mati-fiber_new","mati mati-fiber_pin","mati mati-fiber_smart_record","mati mati-get_app","mati mati-file_upload","mati mati-filter2","mati mati-filter_1","mati mati-filter_2","mati mati-filter_3","mati mati-filter_4","mati mati-filter_5","mati mati-filter_6","mati mati-filter_7","mati mati-filter_8","mati mati-filter_9","mati mati-filter_9_plus","mati mati-filter_b_and_w","mati mati-filter_center_focus","mati mati-filter_drama","mati mati-filter_frames","mati mati-terrain","mati mati-filter_list","mati mati-filter_none","mati mati-filter_tilt_shift","mati mati-filter_vintage","mati mati-find_in_page","mati mati-find_replace","mati mati-fingerprint","mati mati-first_page","mati mati-fitness_center","mati mati-flare","mati mati-flash_auto","mati mati-flash_off","mati mati-flash_on","mati mati-flight_land","mati mati-flight_takeoff","mati mati-flip","mati mati-flip_to_back","mati mati-flip_to_front","mati mati-folder3","mati mati-folder_open","mati mati-folder_shared","mati mati-folder_special","mati mati-font_download","mati mati-format_align_center","mati mati-format_align_justify","mati mati-format_align_left","mati mati-format_align_right","mati mati-format_bold","mati mati-format_clear","mati mati-format_color_fill","mati mati-format_color_reset","mati mati-format_color_text","mati mati-format_indent_decrease","mati mati-format_indent_increase","mati mati-format_italic","mati mati-format_line_spacing","mati mati-format_list_bulleted","mati mati-format_list_numbered","mati mati-format_paint","mati mati-format_quote","mati mati-format_shapes","mati mati-format_size","mati mati-format_strikethrough","mati mati-format_textdirection_l_to_r","mati mati-format_textdirection_r_to_l","mati mati-format_underlined","mati mati-question_answer","mati mati-forward4","mati mati-forward_10","mati mati-forward_30","mati mati-forward_5","mati mati-free_breakfast","mati mati-fullscreen","mati mati-fullscreen_exit","mati mati-functions","mati mati-g_translate","mati mati-games","mati mati-gavel2","mati mati-gesture","mati mati-gif","mati mati-goat","mati mati-golf_course","mati mati-my_location","mati mati-location_searching","mati mati-location_disabled","mati mati-star6","mati mati-gradient","mati mati-grain","mati mati-graphic_eq","mati mati-grid_off","mati mati-grid_on","mati mati-people","mati mati-group_add","mati mati-group_work","mati mati-hd","mati mati-hdr_off","mati mati-hdr_on","mati mati-hdr_strong","mati mati-hdr_weak","mati mati-headset","mati mati-headset_mic","mati mati-healing","mati mati-hearing","mati mati-help2","mati mati-help_outline","mati mati-high_quality","mati mati-highlight","mati mati-highlight_off","mati mati-restore","mati mati-home6","mati mati-hot_tub","mati mati-local_hotel","mati mati-hourglass_empty","mati mati-hourglass_full","mati mati-http","mati mati-lock6","mati mati-photo2","mati mati-image_aspect_ratio","mati mati-import_contacts","mati mati-import_export","mati mati-important_devices","mati mati-inbox3","mati mati-indeterminate_check_box","mati mati-info3","mati mati-info_outline","mati mati-input","mati mati-insert_comment","mati mati-insert_drive_file","mati mati-tag_faces","mati mati-link2","mati mati-invert_colors","mati mati-invert_colors_off","mati mati-iso","mati mati-keyboard","mati mati-keyboard_arrow_down","mati mati-keyboard_arrow_left","mati mati-keyboard_arrow_right","mati mati-keyboard_arrow_up","mati mati-keyboard_backspace","mati mati-keyboard_capslock","mati mati-keyboard_hide","mati mati-keyboard_return","mati mati-keyboard_tab","mati mati-keyboard_voice","mati mati-kitchen","mati mati-label","mati mati-label_outline","mati mati-language","mati mati-laptop_chromebook","mati mati-laptop_mac","mati mati-laptop_windows","mati mati-last_page","mati mati-open_in_new","mati mati-layers","mati mati-layers_clear","mati mati-leak_add","mati mati-leak_remove","mati mati-lens","mati mati-library_books","mati mati-library_music","mati mati-lightbulb_outline","mati mati-line_style","mati mati-line_weight","mati mati-linear_scale","mati mati-linked_camera","mati mati-list4","mati mati-live_help","mati mati-live_tv","mati mati-local_play","mati mati-local_airport","mati mati-local_atm","mati mati-local_bar","mati mati-local_cafe","mati mati-local_car_wash","mati mati-local_convenience_store","mati mati-restaurant_menu","mati mati-local_drink","mati mati-local_florist","mati mati-local_gas_station","mati mati-shopping_cart","mati mati-local_hospital","mati mati-local_laundry_service","mati mati-local_library","mati mati-local_mall","mati mati-theaters","mati mati-local_offer","mati mati-local_parking","mati mati-local_pharmacy","mati mati-local_pizza","mati mati-print","mati mati-local_shipping","mati mati-local_taxi","mati mati-location_city","mati mati-location_off","mati mati-room","mati mati-lock_open","mati mati-lock_outline","mati mati-looks","mati mati-looks_3","mati mati-looks_4","mati mati-looks_5","mati mati-looks_6","mati mati-looks_one","mati mati-looks_two","mati mati-sync2","mati mati-loupe","mati mati-low_priority","mati mati-loyalty","mati mati-mail_outline","mati mati-map2","mati mati-markunread_mailbox","mati mati-memory","mati mati-menu6","mati mati-message","mati mati-mic2","mati mati-mic_none","mati mati-mic_off","mati mati-mms","mati mati-mode_comment","mati mati-monetization_on","mati mati-money_off","mati mati-monochrome_photos","mati mati-mood_bad","mati mati-more","mati mati-more_horiz","mati mati-more_vert","mati mati-motorcycle","mati mati-mouse","mati mati-move_to_inbox","mati mati-movie_creation","mati mati-movie_filter","mati mati-multiline_chart","mati mati-music_note","mati mati-music_video","mati mati-nature","mati mati-nature_people","mati mati-navigation","mati mati-near_me","mati mati-network_cell","mati mati-network_check","mati mati-network_locked","mati mati-network_wifi","mati mati-new_releases","mati mati-next_week","mati mati-nfc","mati mati-no_encryption","mati mati-signal_cellular_no_sim","mati mati-note2","mati mati-note_add","mati mati-notifications","mati mati-notifications_active","mati mati-notifications_none","mati mati-notifications_off","mati mati-notifications_paused","mati mati-offline_pin","mati mati-ondemand_video","mati mati-opacity","mati mati-open_in_browser","mati mati-open_with","mati mati-pages","mati mati-pageview","mati mati-pan_tool","mati mati-panorama","mati mati-radio_button_unchecked","mati mati-panorama_horizontal","mati mati-panorama_vertical","mati mati-panorama_wide_angle","mati mati-party_mode","mati mati-pause4","mati mati-pause_circle_filled","mati mati-pause_circle_outline","mati mati-people_outline","mati mati-perm_camera_mic","mati mati-perm_contact_calendar","mati mati-perm_data_setting","mati mati-perm_device_information","mati mati-person_outline","mati mati-perm_media","mati mati-perm_phone_msg","mati mati-perm_scan_wifi","mati mati-person","mati mati-person_add","mati mati-person_pin","mati mati-person_pin_circle","mati mati-personal_video","mati mati-pets","mati mati-phone_android","mati mati-phone_bluetooth_speaker","mati mati-phone_forwarded","mati mati-phone_in_talk","mati mati-phone_iphone","mati mati-phone_locked","mati mati-phone_missed","mati mati-phone_paused","mati mati-phonelink_erase","mati mati-phonelink_lock","mati mati-phonelink_off","mati mati-phonelink_ring","mati mati-phonelink_setup","mati mati-photo_album","mati mati-photo_filter","mati mati-photo_size_select_actual","mati mati-photo_size_select_large","mati mati-photo_size_select_small","mati mati-picture_as_pdf","mati mati-picture_in_picture","mati mati-picture_in_picture_alt","mati mati-pie_chart","mati mati-pie_chart_outlined","mati mati-pin_drop","mati mati-play_arrow","mati mati-play_circle_filled","mati mati-play_circle_outline","mati mati-play_for_work","mati mati-playlist_add","mati mati-playlist_add_check","mati mati-playlist_play","mati mati-plus_one","mati mati-polymer","mati mati-pool","mati mati-portable_wifi_off","mati mati-portrait","mati mati-power3","mati mati-power_input","mati mati-power_settings_new","mati mati-pregnant_woman","mati mati-present_to_all","mati mati-priority_high","mati mati-public","mati mati-publish","mati mati-queue_music","mati mati-queue_play_next","mati mati-radio","mati mati-radio_button_checked","mati mati-rate_review","mati mati-receipt","mati mati-recent_actors","mati mati-record_voice_over","mati mati-redo3","mati mati-refresh","mati mati-remove","mati mati-remove_circle_outline","mati mati-remove_from_queue","mati mati-visibility","mati mati-remove_shopping_cart","mati mati-reorder","mati mati-repeat2","mati mati-repeat_one","mati mati-replay","mati mati-replay_10","mati mati-replay_30","mati mati-replay_5","mati mati-reply3","mati mati-reply_all","mati mati-report","mati mati-warning","mati mati-restaurant2","mati mati-restore_page","mati mati-ring_volume","mati mati-room_service","mati mati-rotate_90_degrees_ccw","mati mati-rotate_left","mati mati-rotate_right","mati mati-rounded_corner","mati mati-router","mati mati-rowing","mati mati-rss_feed","mati mati-rv_hookup","mati mati-satellite","mati mati-save","mati mati-scanner2","mati mati-school","mati mati-screen_lock_landscape","mati mati-screen_lock_portrait","mati mati-screen_lock_rotation","mati mati-screen_rotation","mati mati-screen_share","mati mati-sd_storage","mati mati-search6","mati mati-security","mati mati-select_all","mati mati-send","mati mati-sentiment_dissatisfied","mati mati-sentiment_neutral","mati mati-sentiment_satisfied","mati mati-sentiment_very_dissatisfied","mati mati-sentiment_very_satisfied","mati mati-settings3","mati mati-settings_applications","mati mati-settings_backup_restore","mati mati-settings_bluetooth","mati mati-settings_brightness","mati mati-settings_cell","mati mati-settings_ethernet","mati mati-settings_input_antenna","mati mati-settings_input_composite","mati mati-settings_input_hdmi","mati mati-settings_input_svideo","mati mati-settings_overscan","mati mati-settings_phone","mati mati-settings_power","mati mati-settings_remote","mati mati-settings_system_daydream","mati mati-settings_voice","mati mati-share4","mati mati-shop2","mati mati-shop_two","mati mati-shopping_basket","mati mati-short_text","mati mati-show_chart","mati mati-shuffle3","mati mati-signal_cellular_4_bar","mati mati-signal_cellular_connected_no_internet_4_bar","mati mati-signal_cellular_null","mati mati-signal_cellular_off","mati mati-signal_wifi_4_bar","mati mati-signal_wifi_4_bar_lock","mati mati-signal_wifi_off","mati mati-sim_card","mati mati-sim_card_alert","mati mati-skip_next","mati mati-skip_previous","mati mati-slideshow","mati mati-slow_motion_video","mati mati-stay_primary_portrait","mati mati-smoke_free","mati mati-smoking_rooms","mati mati-textsms","mati mati-snooze","mati mati-sort","mati mati-sort_by_alpha","mati mati-spa","mati mati-space_bar","mati mati-speaker","mati mati-speaker_group","mati mati-speaker_notes","mati mati-speaker_notes_off","mati mati-speaker_phone","mati mati-spellcheck","mati mati-star_border","mati mati-star_half","mati mati-stars","mati mati-stay_primary_landscape","mati mati-stop","mati mati-stop_screen_share","mati mati-storage","mati mati-store_mall_directory","mati mati-straighten","mati mati-streetview","mati mati-strikethrough_s","mati mati-style","mati mati-subdirectory_arrow_left","mati mati-subdirectory_arrow_right","mati mati-subject","mati mati-subscriptions","mati mati-subtitles","mati mati-subway","mati mati-supervisor_account","mati mati-surround_sound","mati mati-swap_calls","mati mati-swap_horiz","mati mati-swap_vert","mati mati-swap_vertical_circle","mati mati-switch_camera","mati mati-switch_video","mati mati-sync_disabled","mati mati-sync_problem","mati mati-system_update","mati mati-system_update_alt","mati mati-tab2","mati mati-tab_unselected","mati mati-tablet","mati mati-tablet_android","mati mati-tablet_mac","mati mati-tap_and_play","mati mati-text_fields","mati mati-text_format","mati mati-texture","mati mati-thumb_down","mati mati-thumb_up","mati mati-thumbs_up_down","mati mati-timelapse","mati mati-timeline","mati mati-timer","mati mati-timer_10","mati mati-timer_3","mati mati-timer_off","mati mati-title","mati mati-toc","mati mati-today","mati mati-toll","mati mati-tonality","mati mati-touch_app","mati mati-toys","mati mati-track_changes","mati mati-traffic","mati mati-train","mati mati-tram","mati mati-transfer_within_a_station","mati mati-transform","mati mati-translate","mati mati-trending_down","mati mati-trending_flat","mati mati-trending_up","mati mati-tune","mati mati-tv3","mati mati-unarchive","mati mati-undo3","mati mati-unfold_less","mati mati-unfold_more","mati mati-update","mati mati-usb","mati mati-verified_user","mati mati-vertical_align_bottom","mati mati-vertical_align_center","mati mati-vertical_align_top","mati mati-vibration","mati mati-video_call","mati mati-video_label","mati mati-video_library","mati mati-videocam","mati mati-videocam_off","mati mati-videogame_asset","mati mati-view_agenda","mati mati-view_array","mati mati-view_carousel","mati mati-view_column","mati mati-view_comfy","mati mati-view_compact","mati mati-view_day","mati mati-view_headline","mati mati-view_list","mati mati-view_module","mati mati-view_quilt","mati mati-view_stream","mati mati-view_week","mati mati-vignette","mati mati-visibility_off","mati mati-voice_chat","mati mati-voicemail","mati mati-volume_down","mati mati-volume_mute","mati mati-volume_off","mati mati-volume_up","mati mati-vpn_key","mati mati-vpn_lock","mati mati-wallpaper","mati mati-watch2","mati mati-watch_later","mati mati-wb_auto","mati mati-wb_incandescent","mati mati-wb_iridescent","mati mati-wb_sunny","mati mati-wc","mati mati-web","mati mati-web_asset","mati mati-weekend","mati mati-whatshot","mati mati-widgets","mati mati-wifi3","mati mati-wifi_lock","mati mati-wifi_tethering","mati mati-work","mati mati-wrap_text","mati mati-youtube_searched_for","mati mati-zoom_in","mati mati-zoom_out","mati mati-zoom_out_map"]};


var thz_icon_search ={};